//
// any_main.C - an example of how to use C++ ASN.1-BER 
//              for ANY Types
//
// AUTHOR: Mike Sample
// DATE:   92
//

#include <stddef.h>
#include <stdlib.h>
#include <errno.h>
#include <fstream.h>
#include "asn_incl.h"
#include "any_test.h"

main (int argc, char* argv[])
{
    AsnBuf  inputBuf;
    AsnBuf  outputBuf;
    unsigned long int encodedLen;
    unsigned long int decodedLen;
    int      dataSize;
    ifstream dataFile;
    AnyTestType att;

    if (argc != 2)
    {
        cerr << "Usage: " << argv[0] << " <BER data file name>" << endl;
        cerr << "   Decodes the given AnyTestType BER data file" << endl;
        cerr << "   and re-encodes it to stdout" << endl;
        exit(1);
    }

    // open the data file
    dataFile.open(argv[1]);

    if (!dataFile)
    {
        perror("ifstream::open");
        exit(1);
    }

    // get size of the data file file
    dataFile.seekg(0, ios::end);
    dataSize = dataFile.tellg();
    dataFile.seekg(0);

    // read data from file into contiguous block for a buffer
    char data[dataSize];
    dataFile.read(data, dataSize);
    dataFile.close();

    //
    // put the BER data read from the file
    // into buffer format, ready for reading from the
    // beginning
    //
    inputBuf.InstallData((char*)data, dataSize);

    if (!att.BDecPdu(inputBuf, decodedLen))
    {
        cerr << "ERROR - Decode routines failed, exiting..." << endl;
        exit(1);
    }

    cerr  << "decodedValue AnyTestType ::= " << att << endl << endl;

    //
    // allocate a new buffer and set up for writing to
    //
    char outputData[dataSize + 512];
    outputBuf.Init(outputData, dataSize+512);
    outputBuf.ResetInWriteRvsMode();

    if (!att.BEncPdu(outputBuf, encodedLen))
    {
        cerr << "ERROR - Encode routines failed" << endl;
    }

    // write the BER value to cout
    outputBuf.ResetInReadMode();
    for ( ; encodedLen > 0; encodedLen--)
        cout.put(outputBuf.GetByte());

    return(0);
}
