(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* by Ken Brooks; Trexle/M3 by Marc H. Brown                   *)
(* Last modified on Fri Dec  4 14:00:03 PST 1992 by mhb                      *)
(*      modified on Tue Jun 16 12:54:32 PDT 1992 by muller                   *)
(*      modified on Fri Mar 27 02:15:23 1992 by steveg     *)
(*      modified on Mon Feb 11 16:06:44 PST 1991 by brooks     *)

MODULE AnyEvent;

IMPORT VBT;

PROCEDURE FromKey (READONLY event: VBT.KeyRec): Key =
  BEGIN
    RETURN NEW(Key, key := event);
  END FromKey;

PROCEDURE FromMouse (READONLY event: VBT.MouseRec): Mouse =
  BEGIN
    RETURN NEW(Mouse, mouse := event);
  END FromMouse;

PROCEDURE FromPosition (READONLY event: VBT.PositionRec):
  Position =
  BEGIN
    RETURN NEW(Position, position := event);
  END FromPosition;

PROCEDURE FromMisc (READONLY event: VBT.MiscRec): Misc =
  BEGIN
    RETURN NEW(Misc, misc := event);
  END FromMisc;

PROCEDURE TimeStamp (anyevent: T): VBT.TimeStamp =
  BEGIN
    TYPECASE anyevent OF
    | Key (key) => RETURN key.key.time;
    | Mouse (mouse) => RETURN mouse.mouse.time;
    | Position (position) => RETURN position.position.time;
    | Misc (misc) => RETURN misc.misc.time;
    ELSE <* ASSERT(FALSE) *>
    END;
  END TimeStamp;

BEGIN
END AnyEvent.
