(* Copyright (C) 1995, Digital Equipment Corporation                         *)
(* Digital Internal Use Only                                                 *)
(* All rights reserved.                                                      *)
(*                                                                           *)
(* Last modified on Tue Jun 13 09:47:22 PDT 1995 by najork                   *)
(*       Created on Mon Jan 16 10:06:59 PST 1995 by najork                   *)


INTERFACE WinTrestle;

IMPORT ProperSplit, Trestle, TrestleClass, TrestleComm, VBT, WinDef;

TYPE
  T <: Trestle.T;

REVEAL
  TrestleClass.RootVBT <: ProperSplit.T;

(* A Child object serves as the mediator between a top-level VBT.T and
   a Trestle.T.  Calling "trsl.beChild(v)" creates a "Child" object which
   contains Windows-specific data for the top-level VBT.T (such as its 
   window handle). The "Child" object is stored in "v.upRef". *)

TYPE 
  Child <: PubChild;
  PubChild = ProperSplit.Child OBJECT   (* created by WinTrestle.BeChild *)
    hwnd: WinDef.HWND;                  (* The window handle *)
    hdc: WinDef.HDC;                    (* The device context *)
    hpal: WinDef.HPALETTE;              (* The palette handle or NIL *)
    offScreen: BOOLEAN;                 (* TRUE for an off-screen window *)
    sh, sv: VBT.SizeRange;              (* horizontal and vertical 
                                           min/pref/max window sizes *)
    trsl: T;                            (* The Trestle on which the window is 
                                           installed *)
  END;


PROCEDURE Init();

PROCEDURE Enter (trsl: T) RAISES {TrestleComm.Failure};
(* Lock t.  The exception is raised when "t.dead" is true. 
   I'm not sure if that can actually ever happen. *)


PROCEDURE Exit (trsl: T; deltaCoverage: [-1 .. 1] := 0) 
    RAISES {TrestleComm.Failure};

(* Release the lock on "t", after possibly flushing the GDI batch.
   If "t.dead" is true, "TrestleComm.Failure" is raised.

   Each Trestle.T "t" contains a cardinal "t.coverage", which is incremented by
   "deltaCoverage" as the Exit happens.  If the result is zero, the GDI 
   batch is flushed.  A thread making a sequence of calls to Enter/Exit 
   can minimize unnecessary flushing by setting "deltaCoverage" to +1 on 
   the first exit, to -1 on the last exit, and to 0 on the other exits.

   LL = t. *)


END WinTrestle.
