(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Mon Apr  4 17:18:41 PDT 1994 by heydon                   *)
<* PRAGMA LL *>

INTERFACE DblBufferVBT;

(* A "DblBufferVBT.T" is a filter that redirects its child's painting
   operations to an off-screen buffer, and then updates its screen from the
   buffer whenever its "sync" method is invoked.

   The child coordinate system of a double-buffer VBT is a translation of its
   parent's coordinate system. You can compute the translation vector between
   the parent and child by subtracting the northwest corners of their domains.

   A double-buffer VBT "v" does not forward repaint events to its child;
   instead, it repaints by copying from the off-screen buffer.

   A double-buffer VBT maintains a {\it damaged rectangle}, which contains all
   points in the off-screen buffer that have been painted since the last time
   the damaged rectangle was reset. Calling "VBT.Sync" on a double-buffer VBT
   resets its damaged rectangle to be empty. *)

IMPORT VBT, Filter, Rect;

TYPE T <: Filter.T;

(* The call "NEW(DblBufferVBT.T).init(ch)" returns a newly initialized
   double-buffer VBT with child "ch". *)

PROCEDURE GetDamaged(v: VBT.Leaf): Rect.T; <* LL.sup < v *>
(* Requires that some proper ancestor of "v" be a "T". Returns the damaged
   rectangle for the first such ancestor. *)

PROCEDURE SetDamaged(v: VBT.Leaf; READONLY r: Rect.T); <* LL.sup < v *>
(* Requires that some proper ancestor of "v" be a "T". Sets the damaged
   rectangle for the first such ancestor to be "r". *)

(* "GetDamaged" and "SetDamaged" force all paint batches from "v" up to the
   first proper ancestor double-buffer "db" to guarantee that the damaged
   rectangle reflects painting done to these decendants. This will work
   smoothly if "v" is the only leaf decendant of "db" (i.e., if all splits
   between them are filters). Otherwise, you may get the wrong answer due to
   unforced paint batches on other leaf decendants. *)

END DblBufferVBT.
