(* Copyright (C) 1994, Digital Equipment Corporation                         *)
(* Digital Internal Use Only                                                 *)
(* All rights reserved.                                                      *)
(*                                                                           *)
(* Last modified on Tue Jan 24 18:27:39 PST 1995 by najork                   *)
(*       Created on Tue May 24 11:23:24 PDT 1994 by najork                   *)


INTERFACE AnimServer;

IMPORT AnimHandle, RootGO, Wr;

PROCEDURE RegisterRootGO (root : RootGO.T);
(* Adds a root to the set of "RootGO"s managed by the animation server. *)

PROCEDURE PauseAnimHandle (ah : AnimHandle.T);
(* Pauses an animation handle until its endtime has arrived. *)

PROCEDURE SetErrorWr (wr : Wr.T);
(* Set the writer to which animation server error messages will be written to
   be "wr". By default, error messages are written to "Stdio.stderr". *)

PROCEDURE ReportError (msg : TEXT);
(* Write an error message to the error message writer. The default error
   message write is "Stdio.stderr"; it can be changed with "SetErrorWr". *)

VAR
  internalLock : MUTEX;
  externalLock : MUTEX;

(* Locking Order: "externalLock" must be acquired before "internalLock". *)

PROCEDURE IsServer(): BOOLEAN;
(* Debugging procedure. Access to the X display connection must be 
   single-threaded. One way to ensure that is through a locking scheme 
   (Trestle does it that way); another way is by designating a single 
   thread to be the only one allowed to access the X connection. 
   We chose the second approach. The animation server thread is the 
   only thread allowed to call X and PEX proceures. We can ensure proper 
   calling patterns by inserting <* ASSERT AnimServer.IsServer() *> 
   pragmas before every X/PEX call. *)

END AnimServer.
