/*
 * strvars.c -- expand variables in string
 *
 * Part of publib.  See man page for more information.
 * "@(#)publib-strutil:strvars.c,v 1.1 1994/06/20 20:30:49 liw Exp"
 */

#include <assert.h>
#include <string.h>
#include "publib/strutil.h"
#include "publib/errormsg.h"


int strvars(char *str, size_t max, char *(*expand)(const char *)) {
	char *p, *q, *val, name[] = "x";

	assert(str != NULL);
	assert(max >= strlen(str));
	assert(expand != NULL);

	p = str;
	while ((p = strchr(p, '$')) != NULL) {
		if (p[1] == '\0')
			++p;
		else if (p[1] == '$') {
			memmove(p, p+1, strlen(p+1) + 1);
			++p;
		} else {
			if (p[1] == '(') {
				q = strchr(p, ')');
				if (q == NULL) {
					__publib_error("No ) to terminate $(");
					return -1;
				}
				*q = '\0';
				val = expand(p+1);
			} else {
				name[0] = p[1];
				val = expand(name);
			}
			if (val == NULL) {
				__publib_error("Unknown variable");
				return -1;
			}
			if (strlen(val) + (p-str) >= max) {
				__publib_error("Result too long");
				return -1;
			}
			memmove(p, q+1, strlen(q+1)+1);
			memmove(p+strlen(val), p, strlen(p)+1);
			memcpy(p, val, strlen(val));
			p += strlen(val);
		}
	}
	return 0;
}
