
#if 0
typedef struct {
  char *editorid; // EDID
  char *sptfile; // MODL
  float scale; // MODB
  char *leavestexturefile; // ICON
  int formids; // SNAM
  int *formid; // SNAM
  // CNAM, order is yet unknown
  float shadow_radius;
  float leaf_curvature;
  float branch_dimming_value;
  float leaf_dimming_value;
  float minimum_leaf_angle;
  float maximum_leaf_angle;
  float rock_speed;
  float rustle_speed;
  // BNAM
  float billboard_size_x;
  float billboard_size_y;
} ty_record_tree;

ty_record_tree *record_tree_new()
{
  ty_record_tree *p;

  p = (ty_record_tree *)malloc(sizeof(ty_record_tree));
  p->editorid = NULL;
  p->sptfile = NULL;
  p->scale = 1.0;
  p->leavestexturefile = NULL;
  p->formids = 0;
  p->formid = NULL;
  // CNAM
  p->shadow_radius = 0.0;
  p->leaf_curvature = 0.0;
  p->branch_dimming_value = 0.0;
  p->leaf_dimming_value = 0.0;
  p->minimum_leaf_angle = 0.0;
  p->maximum_leaf_angle = 0.0;
  p->rock_speed = 0.0;
  p->rustle_speed = 0.0;
  // BNAM
  p->billboard_size_x = 0.0;
  p->billboard_size_y = 0.0;
  return p;
}

void record_tree_free(ty_record_tree *p)
{
  free(p->formid);
  free(p->leavestexturefile);
  free(p->sptfile);
  free(p->editorid);
  free(p);
}

#endif

#if 1
// Parse and print only.

int parsebuffer_tree(void *b)
{
  int n;
  int mloc;

#if 0
  mloc = buffer_getloc(b);
  buffer_skip_bytes(b,4);
  n = buffer_read_int(b);
  buffer_setloc(b,mloc);
  buffer_skip_bytes(b,20);
  buffer_skip_bytes(b,n);
#else

  int loc;
  int i,nn;
  char *s,*s2;
  void *btmp;
  unsigned char *buffer;
  unsigned char *obuffer = NULL;
  float f;
  unsigned int flags1,flags2,flags;
  int m,nuncomp,nin,nout,err;
  int ndata;

  mloc = buffer_getloc(b);
  buffer_skip_bytes(b,4);
  ndata = buffer_read_int(b);
  flags1 = buffer_read_uint(b);
  printf("flags 1 = ");
  printflags(flags1);
  m = buffer_read_int(b);
  printf("formid = %i\n",m);
  flags2 = buffer_read_uint(b);
  printf("flags 2 = ");
  printflags(flags2);

  buffer_setloc(b,mloc);
  buffer_skip_bytes(b,20);

  if (flags1 & 0x00040000) {
    printf("Data is compressed\n");
    nuncomp = buffer_read_int(b);
    buffer = buffer_getbuf(b);
    nin = ndata-4;
    nout = 10*nin;
    obuffer = (unsigned char *)malloc(nout*sizeof(unsigned char));
    err = uncompress(obuffer,(uLongf *)(&nout),&(buffer[buffer_getloc(b)]),nin);
    if (err == Z_OK) {
      // printf("err = OK\n");
    } else if (err == Z_MEM_ERROR) {
      printf("err = MEM\n");
    } else if (err == Z_BUF_ERROR) {
      printf("err = BUF\n");
    } else if (err == Z_DATA_ERROR) {
      printf("err = DATA\n");
    } else {
      printf("Unknown error\n");
    }
    if (nout != nuncomp) {
      printf("Uncompressed data is of wrong size\n");
      exit(-1);
    }
    btmp = b;
    b = buffer_new(obuffer,(int)nout);
  } else {
    buffer = buffer_getbuf(b);
    btmp = b;
    b = buffer_new(&(buffer[buffer_getloc(btmp)]),ndata);
  }

  while (buffer_eof(b) != 1) {
    loc = buffer_getloc(b);
    s = buffer_read_string4(b);
    printf("Chunk name: %s\n",s);
    if (strcmp(s,"EDID") == 0) {
      n = buffer_read_short(b);
      printf("TREE/EDID %i\n",n);
      s2 = buffer_read_nstring(b,n);
      printf("%s\n",s2);
      free(s2);
    } else if (strcmp(s,"MODL") == 0) {
      n = buffer_read_short(b);
      printf("TREE/MODL %i\n",n);
      s2 = buffer_read_nstring(b,n);
      printf("%s\n",s2);
      free(s2);
    } else if (strcmp(s,"MODB") == 0) {
      n = buffer_read_short(b);
      printf("TREE/MODB %i\n",n);
      f = buffer_read_float(b);
      printf("%f\n",f);
    } else if (strcmp(s,"ICON") == 0) {
      n = buffer_read_short(b);
      printf("TREE/ICON %i\n",n);
      s2 = buffer_read_nstring(b,n);
      printf("%s\n",s2);
      free(s2);
    } else if (strcmp(s,"SNAM") == 0) {
      nn = buffer_read_short(b);
      printf("TREE/SNAM %i\n",nn);
      for (i = 0; i < nn/4; i++) {
	n = buffer_read_int(b); // Seed numbers for random number generator?
	printf("%i\n",n);
      }
    } else if (strcmp(s,"CNAM") == 0) {
      n = buffer_read_short(b);
      printf("TREE/CNAM %i\n",n);
      for (i = 0; i < 8; i++) {
	f = buffer_read_float(b);
	printf("%f\n",f);
      }
    } else if (strcmp(s,"BNAM") == 0) {
      n = buffer_read_short(b);
      printf("TREE/BNAM %i\n",n);
      for (i = 0; i < 2; i++) {
	f = buffer_read_float(b);
	printf("%f\n",f);
      }
    } else {
      printf("Unknown chunk name\n");
      exit(-1);
    }
    free(s);
  }

  buffer_free(b);
  b = btmp;
  buffer_setloc(b,mloc);
  buffer_skip_bytes(b,20);
  buffer_skip_bytes(b,ndata);
  if (flags1 & 0x00040000) {
    free(obuffer);
  }

#endif

  return -1;
}

#endif
