/*
 * warning.c,v 2.0 1992/04/23 02:53:13 ware Exp
 * warning.c,v
 * Revision 2.0  1992/04/23  02:53:13  ware
 * First public release.
 *
 * Revision 1.8  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.7  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.6  1992/02/12  17:16:21  ware
 * Fixed typo in name of XtWarningMsg().
 *
 * Revision 1.5  92/02/12  17:09:33  ware
 * Use XtWarningMsg() if widget is NULL.
 *
 * Revision 1.4  92/02/04  21:25:33  pete
 * Release 44
 *
 * Revision 1.3  91/08/26  11:59:05  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.2  91/07/19  00:59:55  pete
 * Use shorter file names.  Various speedups.
 *
 * Revision 1.1  91/06/14  10:25:06  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/Xo/XoP.h>

/*
 * Provide a simpler method for reporting errors in this widget set.
 */

void
_XoWarn (gw, err_class, err_detail, err_message)
	Widget          gw;		/* widget for context and info */
	char           *err_class;	/* general type of error */
	char           *err_detail;	/* particular error */
	char           *err_message;	/* description */
{
	char           *ptr;
	char            buf[BUFSIZ];
	int             len;
	String          name[1];
	char           *prefix;
	Cardinal        cnt;

	prefix = "%s:";
	len = strlen (err_message) + strlen (prefix) + 1;
	if (len > sizeof (buf))
		ptr = XtMalloc ((unsigned) len);
	else
		ptr = buf;
	strcpy (ptr, prefix);
	strcat (ptr, err_message);
	name[0] = XoName (gw);
	cnt = 1;
	if (!gw)
	{
		XtWarningMsg (err_class, err_detail, "XoError", ptr,
			      name, &cnt);
	}
	else
	{
		XtAppWarningMsg (XtWidgetToApplicationContext (gw),
				 err_class, err_detail, "XoError", ptr,
				 name, &cnt);
	}
	if (len > sizeof (buf))
		XtFree (ptr);
}
