/*
 * Focus	- Utilities to provide allow a widget to grab
 *		  the focus
 * focus.c,v 2.0 1992/04/23 02:52:24 ware Exp
 * focus.c,v
 * Revision 2.0  1992/04/23  02:52:24  ware
 * First public release.
 *
 * Revision 1.5  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.4  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.3  92/02/04  21:25:33  pete
 * Release 44
 *
 * Revision 1.2  91/08/26  11:58:17  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.1  91/07/19  00:58:43  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/CompositeP.h>
#include <X11/Xproto.h>
#include <X11/Xo/XoP.h>
#include <X11/Xo/dbug.h>

/*
 * FIX: We should really be associating this with a shell, but as a quick hack
 *	let's do it this way.
 *
 * FIX: Add a Destroy callback to clean this up.  What about realize?
 */

static Widget   _ThisDumbFocusWidget;

Widget
XoFocusWidgetGet (shell)
	Widget          shell;
{
	if (!XtIsShell (shell))
		return ((Widget) NULL);
	return _ThisDumbFocusWidget;
}

Widget
XoFocusWidgetSet (shell, gw)
	Widget          shell;
	Widget          gw;
{
	Widget          temp;

	DBUG_ENTER ("XoFocusWidgetSet");
	temp = _ThisDumbFocusWidget;

	if (!shell || !XtIsShell (shell))
		DBUG_RETURN ((Widget) NULL);
	else
		_ThisDumbFocusWidget = gw;
	DBUG_PRINT ("focus", ("Setting focus to %s", XoName (gw)));
	DBUG_RETURN (temp);
}

/*
 * Check if there is another widget that already has the focus.  If so,
 * set it to that widget.  If not, then try to set the focus to this widget.
 */

Boolean
XoFocusCheck (gw, event)
	Widget          gw;
	XEvent         *event;
{
	Widget          shell;		/* where we store current focus */
	Widget          focus;		/* widget that has current focus */
	Time            t;

	if ((shell = XoShellGet (gw)) == NULL)
		return False;	/* how could this happen? */

	t = XoEventTime (event);
	if ((focus = XoFocusWidgetGet (shell)) != NULL && focus != gw)
	{
		if (XtCallAcceptFocus (focus, &t))
			return False;
	}
	return XtCallAcceptFocus (gw, &t);
}

static int      (*oldHandler) ();	/* the previous error handler */
static Boolean  xoInputFailed;		/* set if SetInputFocus error */

/*
 * An error handler that is briefly installed as we are changing the
 * keyboard input focus.  It ignores BadMatch errors from SetInputFocus
 * protocol requests.
 */

static int
xoIgnoreFocusError (display, err)
	Display        *display;
	XErrorEvent    *err;
{
	DBUG_ENTER ("xoIgnoreFocusError");
	if (!err)
		DBUG_RETURN (0);
	if (err->error_code == BadMatch &&
	    err->request_code == X_SetInputFocus)
	{
		DBUG_PRINT ("focus", ("SetInputFocus error"));
		xoInputFailed = True;
	}
	else
	{
		(*oldHandler) (display, err);
	}
	DBUG_RETURN (0);
}

/*
 * Determine if we'll accept the keyboard focus.  We accept it only if
 * the window is visible.
 */

Boolean
XoFocusAccept (gw, t)
	Widget          gw;
	Time           *t;
{
	DBUG_ENTER ("xoAcceptFocus");
	if (!gw || !t)
		DBUG_RETURN (False);
	if (!XtIsRealized (gw))
	{
		DBUG_PRINT ("focus", ("Widget %s not realized", XoName (gw)));
		DBUG_RETURN (False);
	}
	/*
	 * We want to install a new error handler that ignores any
	 * SetInputFocus errors.  So we first make sure we've sent and
	 * received all messages -- just in case there is a lingering error.
	 * We install the handler, call the focus change, then Sync again to
	 * make sure this request has gone out and the reply come back.  We
	 * the restore the error handler.
	 */
	XSync (XtDisplay (gw), False);
	oldHandler = XSetErrorHandler (xoIgnoreFocusError);
	xoInputFailed = False;
	XSetInputFocus (XtDisplay (gw), XtWindow (gw),
			RevertToPointerRoot, *t);
	XSync (XtDisplay (gw), False);
	(void) XSetErrorHandler (oldHandler);

	if (xoInputFailed)
	{
		DBUG_PRINT ("focus", ("Error setting focus to %s", XoName (gw)));
		/*
		 * (void) XoFocusAccept (XoFocusWidgetGet (XoShellGet (gw)),
		 * t);
		 */
		DBUG_RETURN (False);
	}
	else
	{
		XoFocusWidgetSet (XoShellGet (gw), gw);
		DBUG_RETURN (True);
	}
}

/*
 * Determine if we'll accept the keyboard focus.  We accept it only if
 * one of the children accepts the focus.
 */

Boolean
XoFocusAcceptComp (gw, t)
	Widget          gw;
	Time           *t;
{
	int             i;
	CompositeWidget w = (CompositeWidget) gw;

	DBUG_ENTER ("XoFocusAcceptComp");
	if (!XtIsRealized (gw))
	{
		DBUG_PRINT ("focus", ("Widget %s not realized", XoName (gw)));
		DBUG_RETURN (False);
	}
	if (!XtIsComposite (gw))
	{
		_XoWarn (gw, "XoFocusAcceptComp", "badArgument", "Widget is not a composite");
		DBUG_RETURN (False);
	}
	for (i = 0; i < w->composite.num_children; i++)
	{
		if (XtCallAcceptFocus (w->composite.children[i], t))
			DBUG_RETURN (True);
	}
	DBUG_RETURN (False);
}
