#
# composite.spec,v 2.3 1992/08/11 00:22:21 pete Exp
#
class CompBase = {
	superclass = Composite;
	class_prefix = "o";
	class_name = "CompBase";
	public_pre_defines = "
#ifndef _XO_XO_H_
#include <X11/Xo/Xo.h>
#endif
";
	private_pre_defines = "
#ifndef _XO_XOP_H_
#include <X11/Xo/XoP.h>
#endif

/*
 * Declare the extension record so all subclasses can have Object's
 * as children.
 */
extern CompositeClassExtensionRec _XoCompExtensionRec;
#define _XoCompExtensionPtr ((XtPointer) & _XoCompExtensionRec)

";
	private_post_defines = "
#define XtInheritTraversalProc ((XtCallbackProc) _XtInherit)
";
	purpose = "
This class should be used to add features such as printing, etc to all
composite widgets in this set.
";
	class_record comp_base = {
		field = (static, "", "Core.initialize", "Initialize", "", "");
		field = (static, "", "Core.set_values", SetValues, "", "");
		field = (static, "", "Composite.geometry_manager",
		         GeometryManager, "", "");
		field = ("", extern, "Core.accept_focus", "XoFocusAcceptComp", "", "");
		field = (static, "", "Core.class_part_initialize",
			ClassPartInit, "", "");
		field = ("", "", "Composite.extension",
			 "_XoCompExtensionPtr", "", "_XoCompExtensionPtr");
		field = (extern, XtCallbackProc, traverse, _XoTraverseCallback,
			"Handler for traverse", XtInheritTraversalProc);
	}
	instance comp_base = {
		(WidgetClass, border_class, "Widget Class of border object",
		 borderClass, Class, ObjectClass, String, "\"None\"",
		 "Object class that implements drawing the border.")
		(Widget, border_widget, "draws the border",
		 "borderWidget", "BorderWidget", "Pointer", Immediate, NULL,
		 "This is the instance of the widget that draws the
		  border You have two choices, either set the
		  \res{WidgetClass} at initialization time or create
		  an object with this widget as it's parent and then
		  use \code{XtSetValues()} to set this resource.  The
		  old widget is destroyed.")
		(Boolean, do_layout, "place widgets flag",
		 doLayout, DoLayout, Boolean, Immediate, "(caddr_t) True",
		 "If this flag is set, then the widget should readjust the 
children whenever changes occur.  If the flag is False, the widget should 
ignore changes in the set of manage children and resize events until the
flag is set to True. When the flag changes from False (do not 
reaarange the children) to True, the complete layout is recalculated.

This flag makes it conveniant to create or manage/unmanage a group of widgets 
one at a time without incurring the overhead of constantly rearranging the 
widgets.")
		(XtCallbackList, traverse, "for keyboard traversals",
		 traverse, Traverse, Callback, Immediate, NULL,
		 "List of callbacks executed to accomplish keyboard
traversals.  There should only be one callback on this list.
Behaviour is undefined if there is more than one callback.  If the
application wishes to change the callback executed, it should delete
the callback list and then install it's own private handler.

At initialization time, the Initialize method executes XtAddCallback()
for this callback list with the value of the call method
\code{traverse} as the callback to execute.  To replace the default
traversal method, subclasses should override this value.

The arguments passed in \code{call\_data} is a structure of type
XoTraversalInfo defined as follows:
\begin{verbatim}
typedef enum 
{
        XoTRAVERSE_PREVIOUS, XoTRAVERSE_NEXT, XoTRAVERSE_HOME,
        XoTRAVERSE_END,
} XoDirection;

/*
 * This information is passed to the traverse callback.
 */
typedef struct _xo_traverse_info 
{
        Widget          t_start;        /* widget moving relative too */
        XoDirection     t_direction;    /* which way to move */
} XoTraverseInfo;
\end{verbatim}

The functions \code{XoTraverse()} or \code{xoTraverseFromString()} are
typically used to cause traversals to occur.  They are conveniance
routines that search the ancestors for ones that know about the
traverse callback and execute the callbacks.")
		("", "Core.border_width", "", "", "", "", "Immediate", "0", "")
	}
	function void traverse = {
		args = {
			(Widget, gw, "constraint widget")
			(XtPointer, client_data, "data from app.")
			(XtPointer, call_data, "from widget")
		}
	}
}

class Box = {
	superclass = CompBase;
	class_prefix = "o";
	class_name = "Box";
	purpose = "
The \class{Box} widget maintains the number of children on each row
based on the number of managed children.  Each child is forced to the
width of the widest managed child and to the height of the highest
managed child.  This insures that all widgets have a consistent
appearance.

The prefered size of the \class{Box} widget is calculated as:

$$
	width = num\_cols \times (max\_width + hoffset) + hoffset
$$
$$
	height = \left\lceil {num\_managed} \over {num\_cols} \right\rceil \times
(max\_height + voffset) + voffset
$$

The $max\_width$ and $max\_height$ are determined by quering the
geometry of each of the managed children to determine the child's
preferred width and height.  The $hoffset$ and $voffset$ correspond to
the \class{Box}'s resources.  The expression for $num\_cols$ is given
below.

$$
	num\_cols = \cases{\lceil\sqrt{num\_managed}\,\rceil & if $num\_managed < 9$\cr
	       \lfloor\sqrt{num\_managed}\rfloor& if $num\_managed \ge 9$}
$$

There are various options to control the resize policy.
The resize policy takes affect when the calculated width and heights
do not match the \class{Box} widget's actual width and height.
The child widgets can either resized to just fill the \class{Box} or
some can be truncated if the \class{Box} is too small or extra space
inserted if the \class{Box} is too large.
";
	class_record box = {
		field = (static, "", "Core.initialize", "Initialize", "", "");
		field = (static, "", "Core.class_initialize", "ClassInit", "", "");
		field = (static, "", "Core.resize", Resize, "", "");
		field = (static, "", "Core.set_values", SetValues, "", "");
		field = (static, "", "Core.query_geometry", QueryGeometry, "", "");
		field = (static, "", "Composite.change_managed", "ChangeManaged","","");
		field = (static, "", "Composite.geometry_manager",
		         GeometryManager, "", "");
		field = ("", "int", filler, "0", "keep compiler happy", "0");
		field = ("", "", "Composite.extension",
			 "_XoCompExtensionPtr", "", "_XoCompExtensionPtr");
	}
	instance box = {
		(Dimension, hoffset, "horizontal separation",
		 hoffset, Offset, Dimension, Immediate, "(caddr_t) 5",
		 "The horizontal distance between widgets in the same
row.  This value is overriden when \res{stretch} is False and
\res{insertHspace} is True.

If the Box is too small, then at least this much space is placed
between each widget.  In addition, this indicates the amount of space
that is always maintainted between any widgets on the left or right border.")

		(Dimension, voffset, "vertical separation",
		 voffset, Offset, Dimension, Immediate, "(caddr_t) 5",
		 "The vertical distance between rows of widgets.
This value is overriden when \res{stretch} is False and
\res{insertVspace} is True.

If the Box is too small, then at least this much space is placed
between each row of widgets.  In addition, the amount of space is
always maintained between the top edge and the top row of widgets and
the bottom edge and bottom row of widgets.")

		(Boolean, shrink, "shrink widgets if too many",
		 "shrink", Shrink, "Boolean", Immediate, "(caddr_t) False",
		 "If this is True and
there is not enough room to display all the children, they are all
resized proportionally so that they fit.  A different scaling factor
is calculated for width and height.  In other words, if the Box is
wide and short, then the child widgets are all proportionally wide and short.

If this is False, then if there is not enough room to display all the
widgets, then any widgets that display past the right or bottom edge
are truncated.

If the Box is very small so that the widgets would have a zero width
or height, then the corresponding dimension is made 4 (arbitrary value).")

		(Boolean, stretch, "stretch widgets if more space",
		 stretch, Stretch, Dimension, Immediate, "(caddr_t) True",
		 "If this is True and there is more room than the
widgets fit into, then each widget should be stretched to fill up the
extra space.  Setting this takes precedence over setting
\res{insertHspace} and \res{insertVspace}.")

		(Boolean, insert_hspace, "add extra space",
		 "insertHspace", Spacers, "Boolean", Immediate,
		 "(caddr_t) True",
		 "If set, then extra space is inserted between the
children in a row to expand the row to the full width of the box.  If
this is False, then the children in each row are always seperated by
\res{hoffset} space.")

		(Boolean, insert_vspace, "add extra space",
		 "insertVspace", Spacers, "Boolean", Immediate,
		 "(caddr_t) True",
		 "If set, then extra space is inserted between
each row to expand the rows to the full height of the box.  If
this is False, then each row is seperated by
\res{voffset} space.")

		(int, num_managed, "number of managed children",
		"", "", "", "", "",
		"This value is calculated in \code{CalcLayout} and
indicates the number of managed children.  It is used to calculate the
number of rows.")
		(Dimension, max_width, "widest child",
		"", "", "", "", "",
		"The widest child of the managed children.  When
sameWidth is True, all children are forced to this same width.")
		(Dimension, max_height, "highest child",
		"", "", "", "", "",
		"The talles child of the managed children.  When sameHeight
is True, all children are forced to this height.")
		(int, num_cols, "number of columns",
		"", "", "", "", "",
		"The number of columns.  This is calculated as:
$$
	num\_cols = \cases{\lceil\sqrt{num\_managed}\,\rceil & if $num\_managed < 9$\cr
	       \lfloor\sqrt{num\_managed}\rfloor& if $num\_managed \ge 9$}
$$")

	}
}

class MenuBox = {
	superclass = Box;
	class_prefix = "o";
	class_name = MenuBox;
	purpose = "
This class implements a Menubar that organizes in a box, just as the
Box widget does.  This is done as a test to insure that it is easy to
subclass an existing composite widget to implement a different layout
policy.";
	class_record menu_box = {
		field = ("static", "XtCallbackProc", "callback_menu", CallbackMenu,
		        "for new callback", XtInheritCallbackMenu);
		field = (static, "", "Core.initialize", "Initialize", "", "");
		field = ("", "", "Composite.extension",
			 "_XoCompExtensionPtr", "", "_XoCompExtensionPtr");
	}
	instance menu_box = {
		(XtCallbackList, callback_menu, "execute for new popup",
		 "callbackMenu", "CallbackMenu", Callback, Immediate, NULL,
		 "This list of callbacks is executed to popup/down the menu.")
		(Widget, "popup", "menushell to hold popups",
		"popup", "Popup", "Widget", "Immediate", "NULL",
		"Menu used as the popup shell.  This is popped
up or down by the callbackMenu callback and replaced with the
call\_data from that callback.")
	}
	function void callback_menu = {
		args = {
			(Widget, gw, "constraint widget")
			(XtPointer, client_data, "data from app.")
			(XtPointer, call_data, "from widget")
		}
	}
}


class MenuShell = {
	superclass = OverrideShell;
	class_prefix = "o";
	class_name = "MenuShell";
	purpose = "
Implements a popup shell that can manage multiple children and is
useful for walking menus.
";
	public_pre_defines = "#ifndef _XO_XO_H_
#include <X11/Xo/Xo.h>
#endif
";
	private_pre_defines = "#ifndef _XO_XOP_H_
#include <X11/Xo/XoP.h>
#endif

static CompositeClassExtensionRec extension =
	{NULL, NULLQUARK, XtCompositeExtensionVersion,
		sizeof (CompositeClassExtensionRec), True};

";
	private_post_defines = "
#define XtInheritTraversalProc ((XtCallbackProc) _XtInherit)
";

	class_record menu_shell = {
		field = ("static", "XtCallbackProc", callback_menu, CallbackMenu,
		        "for new callback", XtInheritCallbackMenu);
		field = (static, XtCallbackProc, traverse, Traverse,
			"Handler for traverse", XtInheritTraversalProc);
		field = (static, "", "Core.set_values", SetValues, "", "");
		field = (static, "", "Core.expose", Redisplay, "", "");
		field = (static, "", "Core.initialize", Initialize, "", "");
		field = (static, "", "Core.class_part_initialize",
			ClassPartInit, "", "");
		field = (static, "", "Core.resize", Resize, "", "");
		field = ("", "", "Core.tm_table", "translations", "", "");
		field = ("", extern, "Core.accept_focus", "XoFocusAcceptComp", "", "");
		field = (static, "", "Composite.change_managed", ChangeManaged, "", "");
		field = ("", "", "Composite.extension", "(XtPointer) &extension",
		         "", "");
	}
	instance menu_shell = {
		(XtCallbackList, callback_menu, "execute for new popup",
		 "callbackMenu", "CallbackMenu", Callback, Immediate, NULL,
		 "This list of callbacks is executed to popup/down the menu.")
		("Widget", current, "current submenu",
		 "current", "Current", "Widget", Immediate, NULL,
		 "Set this to the current child that should be
displayed.  Must be a child of this widget.  This override shell is
resized to the width and height of the child.  The new submenu is
managed if it was not already managed.")
		("Widget", popup_starter, "widget that popped me up",
		 "popupStarter", "PopupStarter", "Widget", Immediate, NULL,
		 "Set this to the widget that caused this menu to be
displayed.  This is used for traversal so that we know our real parent
knows where to go to next.")
		("Boolean", start, "if first in hierarchy",
		 "start", "Start", "Boolean", Immediate, False,
		 "Indicates that this override shell is the beginning
of a possible cascade of menus.  It should be set to True for
MenuShell's that are a child of a MenuBar or for the first in a popup menu.")
		(WidgetClass, border_class, "Widget Class of border object",
		 borderClass, Class, ObjectClass, String,
		 "\"DefaultBorder\"",
		 "Object class that implements drawing the border.")
		(Widget, border_widget, "draws the border",
		 "borderWidget", "BorderWidget", "Pointer", Immediate, NULL,
		 "This is the instance of the widget that draws the border
You have two choices, either set the
\res{WidgetClass} at initialization time or create an object with this
widget as it's parent and then use \code{XtSetValues()} to set this resource.
The old widget is destroyed.")
		("", "Core.border_width", "", "", "", "", "Immediate", "0", "")
		(XtCallbackList, traverse, "for keyboard traversals",
		 traverse, Traverse, Callback, Immediate, NULL,
		 "List of callbacks executed to accomplish keyboard
traversals.  There should only be one callback on this list.
Behaviour is undefined if there is more than one callback.  If the
application wishes to change the callback executed, it should delete
the callback list and then install it's own private handler.

At initialization time, the Initialize method executes XtAddCallback()
for this callback list with the value of the call method
\code{traverse} as the callback to execute.  To replace the default
traversal method, subclasses should override this value.

The arguments passed in \code{call\_data} is a structure of type
XoTraversalInfo defined as follows:
\begin{verbatim}
typedef enum 
{
        XoTRAVERSE_PREVIOUS, XoTRAVERSE_NEXT, XoTRAVERSE_HOME,
        XoTRAVERSE_END,
} XoDirection;

/*
 * This information is passed to the traverse callback.
 */
typedef struct _xo_traverse_info 
{
        Widget          t_start;        /* widget moving relative too */
        XoDirection     t_direction;    /* which way to move */
} XoTraverseInfo;
\end{verbatim}

The functions \code{XoTraverse()} or \code{xoTraverseFromString()} are
typically used to cause traversals to occur.  They are conveniance
routines that search the ancestors for ones that know about the
traverse callback and execute the callbacks.")
		(Boolean, resize_flag, "set if resize is called",
		 "", "", "", "", "",
		 "When making geometry requests of the parent, this
		 flag is used to determine if the Resize method was
		 actually called.  If not, then we must call it by
		 hand.")
	}
	actions = {
		(XoMenuPopdown, XoMenuPopdown,
		 "Remove all currently popped up menus.")
	}
	translations = {
		("<Btn1Up>", "XoMenuPopdown()",
		 "Remove all the popped down menus whenever a button
is released.")
	}
	function void callback_menu = {
		args = {
			(Widget, gw, "constraint widget")
			(XtPointer, client_data, "data from app.")
			(XtPointer, call_data, "from widget")
		}
	}
	function void traverse = {
		args = {
			(Widget, gw, "constraint widget")
			(XtPointer, client_data, "data from app.")
			(XtPointer, call_data, "from widget")
		}
	}
}

class Viewport = {
	superclass = CompBase;
	class_prefix = o;
	class_name = Viewport;
	purpose = "Provide a viewing area for a subset of the child.
		   Adds scrollbars so the user can select the visible
		   portion.

		   There are several choices that can be made about
		   resizing.  The first choice is if scrollbars should
		   only be displayed when needed or always.  The next
		   choice is how is the child resized when the
		   viewport is larger than the childs preferred size.
		   The child can either fill the viewport or be kept
		   at its natural size.";

	class_record viewport = {
		field = (static, "", "Core.initialize", Initialize, "", "");
		field = ("", "", "Composite.extension",
			 "_XoCompExtensionPtr", "", "_XoCompExtensionPtr");
	}
	instance viewport = {
		(Boolean, scrollbar_vert_always, "display scrollbar_v?",
		 scrollbarVertAlways, ScrollbarAlways, Boolean,
		 Immediate, False,
		 "Flag that indicates if the vertical scrollbar should
		  always be displayed or only when there is not enough
		  room for the child.")
		(Boolean, scrollbar_hor_always, "display scrollbar_h?",
		 scrollbarHorAlways, ScrollbarAlways, Boolean,
		 Immediate, False,
		 "Flag that indicates if the horizontal scrollbar should
		  always be displayed or only when there is not enough
		  room for the child.")
		(Boolean, child_fill, "force small child to fill clip",
		 childFill, ChildFill, Boolean, Immediate,
		 "(XtPointer) True",
		 "Flag that indicates even though the prefered size of
		  the child is smaller than the viewport, resize the
		  child to fill the entire viewport.  This applies to
		  both horizontal and vertical dimensions independently.")
		(Window, clip, "child is clipped to this size",
		 "", "", "", "", "",
		 "The parent window of the child.  This insures the
		  child does not overlap the scrollbars")
		(WidgetClass, scrollbar_class, "widget class for scrollbars.",
		 scrollbarClass, Class, ObjectClass, String,
		 "\"Scrollbar\"",
		 "Object class that implements the horizontal and
		 vertical scrollbars.  This must be changed by initialization
		 for it to take effect.")
		(Widget, scrollbar_vertical, "vertical scrollbar",
		 scrollbarVertical, Scrollbar, Pointer, Immediate, NULL,
		 "The widget for vertical scrolling.  The
		  scrollbarClass is used to create this widget.  If
		  XtSetValues() is used to change this, then the old
		  one is destroyed.  However, new callbacks are not
		  added since it is assumed the application wants to
		  add it's own special callbacks.  See the
		  XtNscrollCallback resource to execute scrolling from
		  the application.")
		(Widget, scrollbar_horizontal, "horizontal scrollbar",
		 scrollbarHorizontal, Scrollbar, Pointer, Immediate, NULL,
		 "The widget for horizontal scrolling.  The
		  scrollbarClass is used to create this widget.  If
		  XtSetValues() is used to change this, then the old
		  one is destroyed.  However, new callbacks are not
		  added since it is assumed the application wants to
		  add it's own special callbacks.  See the
		  XtNscrollCallback resource to execute scrolling from
		  the application.")
	}
}
