/*
 * main.c,v
 * Revision 2.0  1992/04/23  02:49:42  ware
 * First public release.
 *
 * Revision 1.1  1991/05/01  13:31:04  pete
 * Initial revision
 *
 */

#include	<stdio.h>
#include	"table.h"
#include	"hash_fixed.h"

extern char	*optarg;
static int	int_compare ();
static int	int_hash ();

main (argc, argv)
int		argc;
char		**argv;
{
	Table	*table;
	int	*values;
	int	num_values = 100;
	int	val;
	int	*fvals;
	int	i;
	int	hash_size = 5;
	int	opt;

	while ((opt = getopt (argc, argv, "n:s:")) != EOF)
	{
		switch (opt)
		{
		case 'n':
			num_values = atoi (optarg);
			break;
		case 's':
			hash_size = atoi (optarg);
			break;
		default:
			fprintf (stderr, "usage: main [-n num_values] [-s hash_table_size]\n");
			exit (1);
		}
	}
	table = table_hash_fixed_create (hash_size, (int (*)()) NULL,
					 int_compare, int_hash);
	if (!table)
	{
		fprintf (stderr, "Unable to create table\n");
		exit (1);
	}

	values = (int *) malloc (sizeof (int) * num_values);
	fvals = (int *) malloc (sizeof (int) * num_values);

	for (i = 0; i < num_values; i++)
	{
		values[i] = (int) random ();
		fvals[i] = 0;
	}

	for (i = 0; i < num_values; i++)
	{
		if (table_add (table, (char *) values[i]) != SUCCESS)
			fprintf (stderr, "table_add error on %dth key (%d)\n",
				 i, values[i]);
	}

	table_hash_fixed_stats (table);
	for (i = 0; i < num_values; i++)
	{
		if ((int) table_find (table, (char *) values[i]) != values[i])
			fprintf (stderr, "table_find error on %dth key (%d)\n",
				 i, values[i]);
	}

	table_first (table);
	for (val = (int) table_next (table); val; val = (int) table_next (table))
	{
		for (i = 0; i < num_values; i++)
		{
			if (val == values[i])
				break;
		}
		if (i < num_values)
			fvals[i] = 1;
	}

	for (i = 0; i < num_values; i++)
	{
		if (!fvals[i])
		{
			fprintf (stderr, "table_next didn't find %dth key (%d)\n",
				 i, values[i]);
		}
	}

	for (i = 0; i < num_values; i++)
	{
		if (table_delete (table, (char *) values[i]) != SUCCESS)
			fprintf (stderr, "table_delete error on %dth key (%d)\n",
				 i, values[i]);
	}
	
	for (i = 0; i < num_values; i++)
	{
		if (table_find (table, (char *) values[i]) != NULL)
			fprintf (stderr, "table_find found %dth key (%d)\n",
				 i, values[i]);
	}
}

static int
int_compare (val1, val2)
char		*val1;
char		*val2;
{
	int	v1, v2;

	v1 = (int) val1;
	v2 = (int) val2;

	return v1 - v2;
}

static int
int_hash (val1)
char		*val1;
{
	int	v1;

	v1 = (int) val1;

	return v1;
}
