#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "build.h"
#include "str_util.h"


/*
 * Add str to the end of list returning a new list of strings.  The list
 * is NULL terminated.  Passing in a NULL list creates a new one
 */

char **
str_list_append (list, str)
char		**list;
char		*str;
{
	char	**ptr;
	int	i;

	if (!str)
		return list;
	if (!list)
	{
		list = (char **) malloc (sizeof (char *));
		if (!list)
		{
			perror ("str_list_append:malloc:");
			return list;
		}
		*list = NULL;
	}
	/*
	 * Find the end of the list
	 */
	for (i = 1, ptr = list; ptr && *ptr; ptr++, i++)
		;
	list = (char **) realloc ((char *) list, sizeof (char *) * (i + 1));
	if (!list)
	{
		perror ("str_list_append:realloc:");
		return list;
	}
	list[i - 1] = str;
	list[i] = NULL;
	return list;
}

/*
 * Take two lists and add the second onto the first and return a newly
 * constructed list.  Neither list1 nor list2 are changed.
 */

char **
str_list_merge (list1, list2)
char		**list1;
char		**list2;
{
	int		count;
	char		**ptr;
	char		**newlist;

	count = 0;
	for (ptr = list1; ptr && *ptr; ptr++)
	{
		++count;
	}
	for (ptr = list2; ptr && *ptr; ptr++)
	{
		++count;
	}
	if (!count)
		return ((char **) NULL);
	newlist = (char **) malloc ((count + 1) * sizeof (char *));
	count = 0;
	for (ptr = list1; ptr && *ptr; ptr++)
	{
		newlist[count++] = str_new (*ptr);
	}
	for (ptr = list2; ptr && *ptr; ptr++)
	{
		newlist[count++] = str_new (*ptr);
	}
	newlist[count] = NULL;
	return newlist;
}

char **
str_list_stylized (words)
char		*words;
{
	char	*ptr;
	char	**list = NULL;
	char	*bufptr;
	char	buf[BUFSIZ];

	if (!words)
		return ((char **) NULL);

	bufptr = buf;
	for (ptr = words; *ptr; ptr++)
	{
		*bufptr++ = *ptr;
		if (isupper (ptr[1]) || !ptr[1])
		{
			*bufptr = '\0';
			bufptr = buf;
			list = str_list_append (list, str_new (buf));
		}
	}
	return list;
}


int
str_list_count (list)
char		**list;
{
	int	count = 0;

	while (list && *list++)
	{
		++count;
	}
	return count;
}


/*
 * Return a copy of the list of strings
 */

char **
str_list_copy (list)
char	**list;
{
	int		i;
	char		**ptr;
	char		**newlist;
	char		**newptr;

	for (i = 1, ptr = list; ptr && *ptr; ptr++, i++)
		;
	newlist = (char **) malloc (sizeof (char *) * i);
	for (ptr = list, newptr = newlist; ptr && *ptr; ptr++, newptr++)
	{
		*newptr = str_new (*ptr);
	}
	*newptr = NULL;
	return newlist;
}

static int
str_list_cmp (cp1, cp2)
char		**cp1, **cp2;
{
	return strcmp (*cp1, *cp2);
}

/*
 * Sort, in place, the list of strings
 */

void
str_list_sort (list)
char	**list;
{
	int		i;
	char		**ptr;

	for (i = 0, ptr = list; ptr && *ptr; ptr++, i++)
		;
	if (i > 1)
		qsort ((char *) list, i, sizeof (char *), str_list_cmp);
}

void
str_list_free (list)
char		**list;
{
	char		**ptr;

	for (ptr = list; ptr && *ptr; ptr++)
	{
		free (*ptr);
		*ptr = NULL;
	}
	if (list)
		free ((char *) list);
}

char *
str_new (str)
char		*str;
{
	if (!str)
		return str;
	return (strcpy (malloc (strlen (str) + 1), str));
}

char *
str_new_add_3 (c1, c2, c3)
char		*c1, *c2, *c3;
{
	int	len;
	char	*str;

#define STRLEN(s)	(s?strlen(s):0)
	len = STRLEN(c1) + STRLEN(c2) + STRLEN(c3) + 1;
	str = malloc (len);
	*str = '\0';
	if (c1)
		strcat (str, c1);
	if (c2)
		strcat (str, c2);
	if (c3)
		strcat (str, c3);
	return str;
}
