/*
 * main.c,v 2.1 1992/07/23 19:02:51 pete Exp
 * main.c,v
 * Revision 2.1  1992/07/23  19:02:51  pete
 * Removing several error messages.
 *
 * Revision 2.0  1992/04/23  02:47:47  ware
 * First public release.
 *
 * Revision 1.11  1992/02/04  21:21:23  pete
 * Release 44
 *
 * Revision 1.10  1991/11/30  19:37:47  pete
 * Generate a file that describes the widget hierarchy.  Add help
 * as a command line option.
 *
 * Revision 1.9  1991/09/12  09:35:45  pete
 * Exit if there are any syntax errors without writing output files.
 * Don't give warning message about override values.
 *
 * Revision 1.8  91/08/26  11:23:23  pete
 * Added RCS keywords.  Use XoProto() for conditional function prototypes.
 * Removed unneeded extern declaration of printf().
 * 
 */

#include <stdio.h>
#include "build.h"
#include "output.h"
#include "str_util.h"

extern class_t	*class_next ();
extern void	class_first ();
extern int	yyparse ();
extern int	getopt ();
extern char	*optarg;
extern int	optind;
extern int	line_number;


XoProto (extern void, print_classes, (options_t *options, FILE *fptr, class_t *parent, int depth, char **list));
XoProto (extern char **, get_classes, (void));
char	**xargv;
int	xargc;
char	*filename;
int	error_count;

void
main (argc, argv)
int		argc;
char		**argv;
{
	options_t	options;
	int		opt;
	char		hierfile[2048];
	char		hierbackup[2048];
	char		*hierdef = "hier.tex";
	FILE		*hier;
	

	options.opt_defdir = "./";
	options.opt_incdir = NULL;
	options.opt_docdir = NULL;
	options.opt_dodoc = 1;
	options.opt_doinc = 1;

	while ((opt = getopt (argc, argv, "i:d:t:h")) != EOF)
	{
		switch (opt)
		{
		case 'i':
			options.opt_incdir = optarg;
			break;
		case 'd':
			options.opt_docdir = optarg;
			break;
		case 't':
			hierdef = optarg;
			break;
		case 'h':
		case '?':
			fprintf (stderr, "usage: [-i include_dir] [-d doc-dir] [-t tree-file]\n");
			exit (1);
		}
	}
	if (!options.opt_incdir)
	{
		options.opt_incdir = options.opt_defdir;
	}
	if (build_dir (options.opt_incdir) < 0)
		exit (1);
	if (!options.opt_docdir)
	{
		options.opt_docdir = options.opt_defdir;
	}
	if (build_dir (options.opt_docdir) < 0)
		exit (1);
	xargv = argv;
	xargc = argc;
	if (optind == argc)
	{
		/*
		 * Read from stdin
		 */
		filename = "stdin";
		yyparse ();
	}
	else
	{
			FILE	*f;
			f = freopen (argv[optind], "r", stdin);
			if (f == NULL)
				perror (argv[optind]);
			else
			{
				printf ("Reading %s\n", argv[optind]);
				filename = argv[optind];
				++optind;
				yyparse();
			}
	}
	if (error_count)
		exit (1);
	sprintf (hierfile, "%s/%s", options.opt_docdir, hierdef);
	if ((hier = output_open (hierfile, hierbackup)) == NULL)
	{
		perror (hierfile);
		fprintf (stderr, "Not generating hierarchy\n");
	}
	if (hier)
		fprintf (hier, "{\\obeylines\\parskip 0pt plus 1pt\n");
	print_classes (&options, hier, (class_t *) NULL, 0, get_classes ());
	if (hier)
	{
		fprintf (hier, "}\n\n");
		output_close (hier, hierfile, hierbackup);
	}
	exit (0);
}

char **
get_classes ()
{
	char		**list = NULL;
	class_t		*class;

	class_first ();
	while ((class = class_next ()) != NULL)
		list = str_list_append (list, str_new (class->cl_name));
	return list;
}

void
print_classes (options, fptr, parent, depth, list)
options_t	*options;
FILE		*fptr;
class_t		*parent;
int		depth;
char		**list;
{
	char		**ptr;
	class_t		*class;
	int		intrinsic;	/* if this is an intrinsics class */

	for (ptr = list; ptr && *ptr; ptr++)
	{
		class = class_lookup (*ptr);
		if (class_lookup (class->cl_superclass) != parent)
			continue;
		if (depth)
			(void) output_goto (stdout, depth * 8, 0);
		printf ("%s", class->cl_name);
		fflush (stdout);
		if (fptr)
		{
			if (var_lookup (class->cl_vars, "nocode") != NULL)
				intrinsic = 1;
			else
				intrinsic = 0;
			fprintf (fptr, "\\hspace{%d\\hierskip} {%s %s} (page \\pageref{def:%s})\n",
				 depth, intrinsic?"\\bf":"", class->cl_name,
				 class->cl_name);
		}
		if (output_includep (options, class))
			printf ("!");
		else
			printf (".");
		fflush (stdout);
		if (output_include (options, class))
			printf ("!");
		else
			printf (".");
		fflush (stdout);
		if (output_c (options, class))
			printf ("!");
		else
			printf (".");
		fflush (stdout);
		if (output_doc (options, class))
			printf ("!");
		else
			printf (".");
		printf ("\n");
		fflush (stdout);
		print_classes (options, fptr, class, depth + 1, list);
	}
}

void
err (message)
char		*message;
{
	fprintf (stderr, "%s:%d: Error %s\n", filename, line_number, message);
}

void
yyerror (message)
char		*message;
{
	++error_count;
	err (message);
}
