/*
 * text.h,v 2.0 1992/04/23 02:47:15 ware Exp
 * text.h,v
 * Revision 2.0  1992/04/23  02:47:15  ware
 * First public release.
 *
 * Revision 1.1  1992/02/23  21:16:25  ware
 * Initial revision
 *
 * Revision 1.1  91/12/16  11:47:50  gnb
 * Add font data collection routines.
 * 
 * Revision 1.0  91/08/22  15:34:09  gnb
 * Initial revision
 * 
 * 
 */

/*

Copyright 1990,1991 by the Massachusetts Institute of Technology

All rights reserved.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of the Massachusetts
Institute of Technology (M.I.T.) not be used in advertising or publicity
pertaining to distribution of the software without specific, written
prior permission.

M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
M.I.T. BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

*/
#ifndef _AtText_h
#define _AtText_h

#include <X11/Xo/FontFamily.h>
    
typedef struct _AtTextToken {
    struct _AtTextToken *next;
    int type;
    int code;
    char *str;

    /* formatting information */
    XFontStruct *font;          /* what font to draw it in */
    short width;       /* bounding box info */
    short ascent;
    short descent;
    short baseline;
    GC		gc;			/* the gc used to draw this */
} AtTextToken;

typedef struct _AtTextPSFormat {
    struct _AtTextPSFormat *next;
    char *font;
    short size;
    short width;
    short ascent;
    short descent;
    short baseline;
} AtTextPSFormat;

typedef struct _AtText {
    AtFontFamily *family;
    int size;
    int style;
    char *str;
    AtTextToken *parsed;
    short width;       /* bounding box info */
    short ascent;
    short descent;
    Boolean rotated;
    XImage *rotated_image;
    unsigned int rotated_depth;
    AtTextPSFormat *psformat;
} AtText;

#define XtRAtJustify "AtJustify"
#define AtTextJUSTIFY_LEFT      0
#define AtTextJUSTIFY_TOP       0    
#define AtTextJUSTIFY_CENTER    1
#define AtTextJUSTIFY_RIGHT     2
#define AtTextJUSTIFY_BOTTOM    2

#ifndef P
# ifdef __STDC__
#  define P(args) args
# else
#  define P(args) ()
# endif 
#endif 

extern AtText* AtTextCreate P((Widget gw, char *, AtFontFamily *,
			       int size, int style,
			       XtGCMask mask, XGCValues *attr));
extern void AtTextDestroy P((Widget gw, AtText *));
extern void AtTextFormat P((Widget gw, AtText *, AtFontFamily *,
			    int size, int style, XtGCMask mask, XGCValues *attr));
extern void AtTextReformat P((Widget gw, AtText *, AtFontFamily *,
			      int size, int style, XtGCMask mask, XGCValues *attr));
extern void AtTextRotate P((AtText *));
extern void AtTextDraw P((Display *, Drawable, GC, AtText *, int, int));
extern void AtTextDrawImage P((Display *, Drawable, GC, AtText *, int, int));
extern void AtTextDrawJustified P((Display *, Drawable, GC, AtText *, int, int,
				int, int, int, int));

#define AtTextWidth(t) ((t)->width)
#define AtTextAscent(t) ((t)->ascent)
#define AtTextDescent(t) ((t)->descent)
#define AtTextHeight(t) ((t)->ascent + (t)->descent)

extern int AtTextPSWidth P((AtText *));
extern int AtTextPSAscent P((AtText *));
extern int AtTextPSDescent P((AtText *));
extern void AtTextPSDraw P((FILE *, AtText *, int, int));
extern void AtTextWritePostscriptProlog P((FILE *));

extern void AtTextStartFontCollection P((void));
extern void AtTextEndFontCollection P((FILE *));

#endif
