#include "udposix.h"
#include <stddef.h>		/* for size_t */
#include <stdio.h>
#include <string.h>
#include "udalloc.h"
#include "uderrmsg.h"


/*
 * Duplicate a string.
 */

    char*
udstrdup(from)
    const char	*from;
{
    char	*to;

    if (from == NULL) {
	to	= NULL;
    } else {
	int		nbytes	= strlen(from) + 1;

	to	= UD_ALLOC(nbytes, char);

	if (to == NULL) {
	    udadvise("udstrdup: Couldn't allocate buffer.");
	} else {
	    (void)strcpy(to, from);
	}
    }

    return to;
}
