/*
 * $Id: udrm.c,v 2.4 1991/04/10 19:37:15 steve Exp $
 *
 * $__Header$
 *
 *	This file contains an implementation of a resouce-manager that is
 *	independent of the X resource-manager API (because DEC's API differs 
 *	from the X-consortium's -- sigh).  The idea is to map the peculiarities
 *	of the underlying resource-manager into a common API.
 *
 *	The functions are ordered alphabetically.
 */

/*LINTLIBRARY*/

#include "udposix.h"
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "udres.h"
#include "udrm.h"


    int
UrmGetFileDatabase(filename, db)
    char	*filename;
    UrmDatabase	*db;
{
    int		success;

    assert(filename != NULL);

    *db	= XrmGetFileDatabase(filename);

#   ifdef vms
	success	= *db != 0;
#   else	/* !vms */
	success	= *db != NULL;
#   endif	/* !vms */

    return success;
}


    int
UrmGetStringDatabase(string, db)
    char	*string;
    UrmDatabase	*db;
{
    int		success;

    *db	= XrmGetStringDatabase(string);
    
#   ifdef vms
	success	= 1;
#   else	/* !vms */
	success	= *db != NULL;
#   endif	/* !vms */

    return success;
}
    

    int
UrmGetResource(db, NameKey, ClassKey, type, value)
    UrmDatabase	db;
    char	*NameKey, *ClassKey;
    char	**type;
    UrmValue	*value;
{
    return XrmGetResource(db, NameKey, ClassKey, type, value);
}


    int
UrmInitialize()
{
    int		success;

#   ifdef vms
	success	= x$rm_initialize();

#   else	/* !vms */
	XrmInitialize();
	success	= 1;

#   endif	/* !vms */

    return success;
}


    void
UrmMergeDatabases(src_db, dst_db)
    UrmDatabase	src_db, *dst_db;
{
    XrmMergeDatabases(src_db, dst_db);
}


    void
UrmPutLineResource(db, line)
    UrmDatabase	*db;
    char	*line;
{
    XrmPutLineResource(db, line);
}


    void
UrmPutStringResource(db, StoreKey, value)
    UrmDatabase	*db;
    char	*StoreKey;
    char	*value;
{
    XrmPutStringResource(db, StoreKey, value == NULL ? "" : value);
}
