/*
 * $Id: udoutdir.c,v 2.6 1991/07/31 20:29:05 steve Exp $
 *
 * $__Header$
 */

/*LINTLIBRARY*/

#include "udposix.h"
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>		/* for unlink() */
#include <sys/types.h>
#include <errno.h>
#include "udres.h"
#include "uderrmsg.h"

#ifndef PATH_MAX
#   define PATH_MAX	_POSIX_PATH_MAX
#endif

#ifndef NAME_MAX
#   define NAME_MAX	_POSIX_NAME_MAX
#endif

/*
 * Convert an output directory.
 */

    int
UdOutDir(str, bin, mode)
    VOIDP	str;
    VOIDP	bin;
    int		mode;
{
    int		success	= 1;		/* Routine status = success */
    static char	me[]	= "UdOutDir";

    if (success = UdString(str, bin, mode)) {

	if (mode == UD_MNEMONIC) {
	    *(char**)str	= "OutDir";

	} else if (mode == UD_TO_BINARY && str != NULL) {
	    int		type, access;
	    int	 	fd;
	    char	path[PATH_MAX+1+NAME_MAX];

	    success	= 0;			/* Make success an exception */

	    path[sizeof(path)-1]	= 0;
	    (void) strncpy(path, (char*)str, 
			   (size_t)(sizeof(path)-NAME_MAX-2));
#ifdef vms
	    (void) sprintf(path+strlen(path), "UD.%lu",
			   (unsigned long)getpid());
#else
	    (void) sprintf(path+strlen(path), "/UD.%lu", 
			   (unsigned long)getpid());
#endif

#ifdef DEBUG
	    (void) udadvise("%s: test path = \"%s\".", me, path);
#endif

	    errno	= 0;
	    fd	= creat(path, (mode_t)0);

	    if (fd == -1) {
		switch (errno) {
		default:
		    udadvise("%s: Can't access output directory \"%s\".", 
			me, (char*)str);
		    break;
		case ENAMETOOLONG:
		    udadvise(
			"%s: Output directory name \"%s\" is too long.", 
			me, (char*)str);
		    break;
		case ENOSPC:
		    udadvise("%s: Output directory \"%s\" doesn't exist.", 
			me, (char*)str);
		    break;
		case ENOTDIR:
		    udadvise("%s: \"%s\" isn't a directory.", 
			me, (char*)str);
		    break;
		}
	    } else {
		(void) close(fd);
		(void) unlink(path);
		success	= 1;
	    }
	}
    }

    return success;
}
