/*
 * $Id: udposix.h,v 1.1 1991/07/26 20:33:16 steve Exp $
 *
 * Configuration header-file for the VMS 5.4 version of the Unidata 
 * POSIX programming environment.
 */

#ifndef UDPOSIX_H_INCLUDED
#define	UDPOSIX_H_INCLUDED

#define	_POSIX_SOURCE

/*
 * Set NDEBUG according to DEBUG.
 */
#ifdef DEBUG
#   undef NDEBUG
#else
#   define NDEBUG
#endif

/*
 *	Macro for declaring functions regardless of the availability of 
 *	function prototypes.  NB: will need double parens in actual use (e.g.
 *	"int func PROTO((int a, char *cp))").
 */
#define	PROTO(a)	a


typedef	int		bool;
#define	NO		0
#define	YES		1
#define signed
typedef void		*VOIDP;
typedef void		*voidp;
#define FREE_ARG	void*			/* argument to free(3) */

#ifdef __STDC__
#   define	GLUE(a,b)	a##b
#   define	MAKESTRING(s)	# s
#else
#   define	GLUE(a,b)	a/**/b
#   define	MAKESTRING(s)	"s"
#endif

#endif	/* UDPOSIX_H_INCLUDED not defined */
