/*
 * $Id: stdlib.h,v 1.4 1991/03/28 00:04:43 steve Exp $
 * $__Header$
 *
 * <stdlib.h> header-file for the SunOS 4.1 version of the Unidata POSIX
 * programming environment.
 */

#ifndef UDPOSIX_H_INCLUDED
#   include "/usr/5include//stdlib.h"
#else

#ifndef	UD_STDLIB_H_INCLUDED
#define	UD_STDLIB_H_INCLUDED

/*
 *	Include appropriate implementation-supplied header files.
 */
#include "/usr/5include/stdlib.h"
#include <floatingpoint.h>	/* for strtod */

/*
 *	Handle missing symbols that need definitions.
 */
extern long	strtol		PROTO((char *s, char **endp, int base));

#define	labs(i)		((long)abs(i))
#define	atexit(f)	(void)on_exit(f, (VOIDP)NULL)
#define	EXIT_SUCCESS	0
#define	EXIT_FAILURE	1

/*
 *	The following functions don't appear to exist in the library:
 *
 *	unsigned long	strtoul	PROTO((const char *s, char **endp, int base));
 *	div_t		div	PROTO((int num, int denom));
 *	ldiv_t		ldiv	PROTO((long num, long denom));
 */

#endif	/* !UD_STDLIB_H_INCLUDED */

#endif	/* UDPOSIX_H_INCLUDED defined */
