/*
 * $Id: signal.c,v 1.1 1991/05/06 13:58:49 steve Exp $
 *
 * POSIX signal interface layered atop NextOS 2.0 signal interface.
 */

#include "udposix.h"
#include <stdio.h>		/* for NULL */
#include <signal.h>
#include <errno.h>

#undef	SIGMASK
#define	SIGMASK(num)		((sigset_t)1 << (num)-1)


/*
 * Clear a signal-mask.
 */
    int
sigemptyset(mask)
    sigset_t	*mask;
{
    int		retval;

    if (mask == NULL) {
	errno	= EINVAL;
	retval	= -1;
    } else {
	*mask	= 0;
	retval	= 0;
    }

    return retval;
}


/*
 * Add a signal to a signal-mask.
 */
    int
sigaddset(mask, num)
    sigset_t	*mask;
    int		num;
{
    int		retval;

    if (num < 1 || mask == NULL) {
	errno	= EINVAL;
	retval	= -1;
    } else {
	*mask	|= SIGMASK(num);
	retval	= 0;
    }

    return retval;
}


/*
 * Delete a signal from a signal-mask.
 */
    int
sigdelset(mask, num)
    sigset_t	*mask;
    int		num;
{
    int		retval;

    if (num < 1 || mask == NULL) {
	errno	= EINVAL;
	retval	= -1;
    } else {
	*mask	&= ~SIGMASK(num);
	retval	= 0;
    }

    return retval;
}


/*
 * Process a signal-mask.
 */
    int
sigprocmask(action, in_mask, out_mask)
    int		action;
    sigset_t	*in_mask;
    sigset_t	*out_mask;
{
    int		MyErrno	= errno;

    errno	= 0;

    if (out_mask != NULL)
	*out_mask	= sigblock(0L);

    if (in_mask != NULL) {
	switch (action) {
	case SIG_BLOCK:
	    (void)sigblock(*in_mask);
	    break;
	case SIG_UNBLOCK:
	    (void)sigsetmask(sigblock(0L) & ~*in_mask);
	    break;
	case SIG_SETMASK:
	    (void)sigsetmask(*in_mask);
	    break;
	default:
	    errno	= EINVAL;
	}
    }

    if (errno == 0) {
	errno	= MyErrno;
	MyErrno	= 0;
    } else {
	MyErrno	= -1;
    }

    return MyErrno;
}


/*
 * Block the signals of a signal-mask and suspend the process.
 *
 * NB: Under the UNICOS operating system, the sigpause() call must,
 * instead, be bsdsigpause().
 */
    int
sigsuspend(mask)
    sigset_t	*mask;
{
    return sigpause(*mask);
}
