/*
 * $Id: udalloc.h,v 2.3 1991/04/09 22:08:24 steve Exp $
 * $__Header$
 */

#ifndef UD_ALLOC_H_INCLUDED
#define UD_ALLOC_H_INCLUDED

/*
 * This header-file requires that <stddef.h> have been #include'd first
 * (for `size_t').
 */

/*
 *	Macro for declaring functions regardless of the availability of 
 *	function prototypes.  NB: will need double parens in actual use (e.g.
 *	"int func PROTO((int a, char *cp))").
 */
#ifndef	PROTO
#   if defined(__STDC__) || defined(__GNUC__) \
	|| defined(__cplusplus) || defined(c_plusplus)
#	define	PROTO(a)	a
#   else
#	define	PROTO(a)	()
#   endif
#endif

#ifndef	VOIDP
#   define	VOIDP		void*
#endif


#include <stdlib.h>


/*
 *	Interface to the Unidata memory-allocation abstraction:
 */
extern VOIDP	udmalloc	PROTO((size_t nbytes));
extern VOIDP	udrealloc	PROTO((VOIDP ptr, size_t nbytes));


/*
 *	Some macros to make life easier:
 */
#define UD_ALLOC(theNum, theType) \
	    (theType*)udmalloc((size_t)(sizeof(theType)*(theNum))) 

#define UD_REALLOC(ptr, theNum, theType) \
	    (theType*)udrealloc((VOIDP)(ptr), \
		    (size_t)(sizeof(theType)*(theNum)))

#define FREE(ptr)		(void)free((FREE_ARG)(ptr))

#endif	/* !UD_ALLOC_H_INCLUDED */
