// -*- C++ -*-

//<copyright>
//
// Copyright (c) 1995
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name:        urlserver.h
//
// Purpose:     server for fetching texture images and inline scenes from the Web
//              fetches URL via HTTP protocol
//              (compare with ImageServer doing the same job with Harmony)
//
// Created:     29 Nov 1995   Michael Pichler
//
// Changed:     29 Nov 1995   Michael Pichler
//
// $Id: urlserver.h,v 1.1 1995/12/20 15:53:42 mpichler Exp $
//
//</file>



#ifndef harmony_scene_urlserver_h
#define harmony_scene_urlserver_h


#include "slist.h"


class Scene3D;
class QvWWWInline;
class URLRequest;



// URLServer
// keeps a list of URL request, which are handled sequentially
// does not contain caching at the moment

class URLServer
{
  public:
    URLServer (                         // constructor
      Scene3D* scene                    //   current scene (non nil)
    );
    ~URLServer ();

    void clearAllRequests ();           // cancel all current requests

    void appendInlineRequest (          // request WWWInline
      QvWWWInline* node,                //   node (where attach inline data)
      const char* url,                  //   requested URL (of data to be fetched)
      const char* docurl                //   URL of requesting document (for relative URLs)
    );

//     void appendTextureRequest (         // request for texture image
//     );

    void handleRequests (int texturesalso);

  private:
    Scene3D* scene_;
    int reqtextures_;

    URLRequest* pendinginlinereq_;
    slist inlinerequests_;

    URLRequest* pendingtexturereq_;
    slist texturerequests_;

}; // URLServer

#endif
