// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1993 
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        dcerror.C
// 
// Purpose:     
// 
// Created:     3 Dec 93   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// 
// </file> 
#include "dcerror.h"

#include "assert.h"
#include "language.h"




// #define VERBOSE
// #include "verbose.h"



static const char* classname = "Document Cache Error" ;

static const char* description [DcErrorBase::NERRORS+1][HgLanguage::NumLanguages] = {
   /*OK*/              {"No Error", "Kein Fehler"},
   /*REQUESTPENDING*/  {"Request pending", "Anfrage ausstaendig"},
   /*NOCONNECTION*/    {"No connection to document server", 
                        "Keine Verbindung zum Document Server"},
   /*WRONGVERSION*/    {"Wrong version", "Falsche Version"},
   /*NOTINITIALIZED*/  {"Not initialized", "Nicht initialisiert"},
   /*BADREQUEST*/      {"Bad request", "Nix verstehen"},
   /*BADLRN*/          {"Bad document number", "Falsche Dokumentnummer"},
   /*OPENSTORE_WRITE*/ {"Cannot write to local store", 
                        "Schreiben in den lokalen Speicher nicht moeglich"},
   /*OPENSTORE_READ*/  {"Cannot read from local store", 
                        "Lesen vom lokalen Speicher nicht moeglich"},
   /*READSTORE*/       {"Store read error", "Fehler beim Lesen vom Speicher"},
   /*WRITESTORE*/      {"Write error", "Fehler beim Schreiben"},
   /*CLOSESTORE*/      {"Close error", "Fehler beim Schliessen"},
   /*BADPATH*/         {"Bad path", "Ungueltiger Pfad"},
   /*NOPATH*/          {"No path", "Kein Pfad"},
   /*OPENFILE*/        {"Cannot open file", "Datei kann nicht geoeffnet werden"},
   /*READFILE*/        {"Cannot read from file", "Datei kann nicht gelesen werden"},
   /*WRITEFILE*/       {"Cannot write to file", "Datei kann nicht geschrieben werden"},
   /*CONNECTCLIENT*/   {"Could not connect to client", "Client nicht erreichbar"},
   /*ACCEPT*/          {"Could not accept connection", "Verbindung kann nicht angenommen werden"},
   /*READSOCKET*/      {"Could not read from socket", "Lesen vom Socket nicht moeglich"},
   /*WRITESOCKET*/     {"Could not write to socket", "Schreiben aufs Socket nicht moeglich"},
   /*NOHEADER*/        {"No header", "Kein Header"},
   /*TOOMUCHDATA*/     {"Received too much data", "Zu viele Daten empfangen"},
   /*TOOFEWDATA*/      {"Received too few data", "Zu wenig Daten empfangen"},
   /*SERVERTIMEOUT*/   {"Document server did not respond", "Doc. Server hat nicht geantwortet"},
   /*NOTIMPLEMENTED*/  {"Not implemented", "Nicht implementiert"},
   /*USERBREAK*/       {"User break", "Verbindung abgebrochen"},
   /*INTERNAL*/        {"Internal error", "Interner Fehler"},
   /*INVALIDOBJECT*/   {"Invalid object", "Ungueltiges Objekt"},
   /*JOBTIMEOUT*/      {"Job timed out", "Job gestorben weil nix getan"},
   /*OPENPORT*/        {"Cannot open port", "Kann keinen weiteren Port oeffnen"},
   /*NODATA*/          {"Received no data", "Keine Daten empfangen"},
   /*NOPORT*/          {"No port to handle this request", 
                        "Kein Port fuer diesen Auftrag vorhanden"},
   /*NOTCACHED*/       {"Document not cached", "Dokument nicht gecached"},
   /*BADCACHETYPE*/    {"Bad cache type", "Kein gueltiger Cachetyp"},
   /*OPENCACHE_WRITE*/ {"Cannot write to cache", "Schreiben in den Cache nicht moeglich"},
   /*OPENCACHE_READ*/  {"Cannot read from cache", "Lesen vom Cache nicht moeglich"},
   /*NOSOURCE*/        {"Do not know what to read", ""},
   /*CLOSECACHE*/      {"Could not insert into cache", "Konnte nicht in den Cache einfuegen"},
   /*CONNECTREMOTE*/   {"Could not connect to remote server", 
                        "Konnte keine Verbindung zum entfernten Server herstellen"},
   /*LOCKREFUSED*/     {"Lock refused", "Sperren verweigert"},
   /*CREATESTORE*/     {"Could not create local store", "Konnte lokalen Speicher nicht anlegen"},
   /*CREATECACHE*/     {"Could not create cache store", "Konnte Cachespeicher nicht anlegen"},
   /*CONNECT*/         {"Could not connect", "Konnte Verbindung nicht herstellen"},
   /*INVALIDADDRESS*/  {"Invalid address", "Ungueltige Adresse"},
   /*AINTNOCHILDREN*/  {"Ain't no children", "Kann keine Kinder haben"},
   /*AINTNODATA*/      {"Ain't no data", "Habe keine Daten"},
   /*NERRORS*/         {"No decription available", "Keine Beschreibung vorhanden"}
} ;


// --------------------------------------------------------------------
DcErrorBase::DcCode DcErrorBase :: dcCode (int code) {
   hgassert (ErrorBase::classId(code)==ErrorBase::DC,
             "DcErrorBase::dcCode(int code): error class of code not DC") ;
   int tmp = ErrorBase::realCode (code) ;
   return tmp>=OK && tmp<NERRORS ? DcErrorBase::DcCode(tmp) : NERRORS ;
}

ErrorBase::ErrorClass DcErrorBase :: getClassId() const {
   return ErrorBase::DC ;
}

const char* DcErrorBase :: getClassName (int) const {
   // ++++ language not supported
   return classname ;
}

const char* DcErrorBase :: getDescription (int code, int language) const {
   hgassert (classId(code)==ErrorBase::DC, "DcErrorBase::getDescription(): error class not DC") ;
   hgassert (language>=0&&language<HgLanguage::NumLanguages, 
             "DcErrorBase::getDescription(): invalid language") ;
   int dccode = realCode (code) ;
   int erridx = dccode<=NERRORS? dccode: NERRORS ;
   int langidx = description[erridx][language]? language: HgLanguage::English ;
   return description[erridx][langidx] ;
}

boolean DcErrorBase :: getOk (int code) const {
   return dcCode(code)==OK ;
}


// --------------------------------------------------------------------
DcError :: DcError (const DcError& err) {
   operator = (err) ;
}
DcError :: DcError (DcErrorBase::DcCode c) {
   operator = (c) ;
}
DcError :: DcError (int c) {
   operator = (c) ;
}

DcError& DcError :: operator = (const DcError& err) {
   code_ = err.code_ ;
   return *this ;
}
DcError& DcError :: operator = (DcErrorBase::DcCode c) {
   hgassert (c>=0&&c<=255, "DcError::operator=(DcErrorBase::DcCode): code too large") ;
   code_ = (ErrorBase::DC<<8) | c ;
   return *this ;
}
DcError& DcError :: operator = (int c) {
   hgassert (ErrorBase::classId(c)==DC, "DcError::operator=(int): classid != DC") ;
   hgassert (realCode(c)>=0&&realCode(c)<=255, "DcError::operator=(int): code too large") ;
   code_ = c ;
   return *this ;
}

ErrorBase::ErrorClass DcError :: classId() const {
   return getClassId() ;
}

const char* DcError :: className (int language) const {
   return getClassName (language) ;
}

const char* DcError :: description (int language) const {
   return getDescription (code_, language) ;
}

boolean DcError :: ok() const {
   return getOk (code_) ;
}

boolean DcError :: operator !() const {
   return ok() ;
}

DcError :: operator void*() const {
   return (void*)(!ok()) ;
}

boolean DcError :: operator != (DcErrorBase::DcCode c) const {
   hgassert (c>=0&&c<=255, "DcError::operator!=(DcErrorBase::DcCode): code too large") ;
   return dcCode() != c ;
}

boolean DcError :: operator == (DcErrorBase::DcCode c) const {
   hgassert (c>=0&&c<=255, "DcError::operator==(DcErrorBase::DcCode): code too large") ;
   return dcCode() == c ;
}




