// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>


//<file>
//
// Name:       colselect.h
//
// Purpose:    Interface to colour selector, which lets choose
//             a colour from a colour table, and also is an
//             observer which reacts on changes of ocolor
//
// Created:     3 May 94    Michael Pichler
//
// Modified:   20 May 94    Michael Pichler
//
//
//</file>



#ifndef harmony_widgets_colselect_h
#define harmony_widgets_colselect_h


#include <InterViews/input.h>
#include <InterViews/observe.h>
class Brush;
class Color;

class OColor;



//<class>
//
//
// Name: ColorSelector
//
// This class lets the user select one out of a number of colours to set
// the colour of an OColor. In the other direction, when the colour of
// OColor is changed, the nearest matching color is highlighted
//
//
//</class>



class ColorSelector: public InputHandler, public Observer
{
  public:
    ColorSelector (OColor*, Style*);
    virtual ~ColorSelector ();

    // InputHandler
    virtual void press (const Event&);
    void keystroke (const Event&);

    virtual void allocate (Canvas*, const Allocation&, Extension&);
    virtual void draw (Canvas*, const Allocation&) const;

    virtual void redraw () const;
    virtual void undraw ();

    // Observer
    virtual void update (Observable*);
    virtual void disconnect (Observable*);

  private:
    void selectCell (int, int, int);

    enum { NUMCOLUMNS = 8, NUMROWS = 19, NUMCOLORS =  NUMCOLUMNS * NUMROWS };
    int matchrow_, matchcol_;

    int exactmatch_;
    Brush* thinbrush_;

    Canvas* canvas_;  // for redraw
    Extension extension_;

    OColor* oc_;
    Color* color_ [NUMROWS][NUMCOLUMNS];
    static const int colortable_ [NUMROWS][NUMCOLUMNS][3];
};



#endif
