/*
 * File :       viewer.h
 *
 * Purpose :    Interface to class HgViewer
 *
 * Created :    12 Jun 92    Keith Andrews, IICM
 *
 * Modified :   16 Jul 92    Keith Andrews, IICM
 *
 */

#ifndef viewer_h
#define viewer_h


//
// class HgViewer
//
// Abstract Viewer Class. HgViewers display Hyper-G documents.
//


class HgViewer
{
public:
  HgViewer() {}
  virtual ~HgViewer() {}


  virtual void load(                             // load document
    const char* doc,                             //   document
    const char* anchors                          //   source anchors
  ) = 0 ;


  virtual void browse(                           // browse current document
    const char* dest = 0                         //   optional destination anchor
  ) = 0 ;


  virtual void terminate() = 0 ;                 // terminate viewer


//  virtual void Output( FILE* pipe ) = 0 ;
//  virtual int Pipe( const char* command ) = 0 ;
//  virtual int MailTo( HGObject*, const char* address, HGObject::mail_mode ) = 0 ;
} ;


#endif
