// This may look like C code, but it is really -*- C++ -*-

// **********************************************************
// File rvwboss.h
// ----------------------------------------------------------
// Created: J. Faschingbauer
// **********************************************************
#ifndef have_rvwboss_h
#define have_rvwboss_h

#include "hgviewer.h"
#include "vwboss.h"
#include "rvwprot.h"

#include <hyperg/Dispatch/rpchdr.h>
#include <hyperg/Dispatch/rpcstream.h>
#include <hyperg/Dispatch/rpcreader.h>
#include <hyperg/Dispatch/rpcwriter.h>
#include <hyperg/Dispatch/rpcservice.h>




class RemoteWriter ;
class RemoteReader ;

// **********************************************************
// class RemoteViewerBoss
// **********************************************************
class RemoteViewerBoss : public ViewerBoss {
public:
   RemoteViewerBoss (int fd) ;
   virtual ~RemoteViewerBoss() ;

   virtual void follow_link (const char*, HgViewer*) ;
   virtual void viewer_error (HgViewer*) ;
   virtual void viewer_terminated (HgViewer*) ;

   RemoteReader* reader() ;
   RemoteWriter* writer() ;
   HgViewer*     viewer() ;
   void viewer (HgViewer*) ;

   static const boolean binary ;

private:
   RemoteReader* _reader ;
   RemoteWriter* _writer ;
   HgViewer* _viewer ;
} ;

inline RemoteReader* RemoteViewerBoss :: reader() {
   return _reader ;
}

inline RemoteWriter* RemoteViewerBoss :: writer() {
   return _writer ;
}

inline HgViewer* RemoteViewerBoss :: viewer() {
   return _viewer ;
}

inline void RemoteViewerBoss :: viewer (HgViewer* viewer) {
   _viewer = viewer ;
}


// **********************************************************
// class RemoteWriter
// **********************************************************
class RemoteWriter : public RpcWriter, virtual public FromRViewerProtocol {
public:
   RemoteWriter (int fd) ;
   ~RemoteWriter () {}
   
   void sendReady() ;
   void sendFollowLink (const char*) ;
   void sendError (HgViewerError) ;
   void sendTerminated() ;
} ;



// **********************************************************
// class RemoteReader
// **********************************************************
class RemoteReader : public RpcReader, virtual public ToRViewerProtocol {
public:
   RemoteReader (rpcstream*, RemoteViewerBoss*) ;
   virtual ~RemoteReader () {}
   
   void 	run() ;
   void 	quitRunning() ;
   
   RemoteViewerBoss* boss() { return _boss; } ;

protected:
//   virtual int  inputReady (int fd) ;
   virtual void connectionClosed (int fd) ;

private:
   RemoteViewerBoss* _boss ;
   boolean _running ;
   
   static void receive_READY     (RpcReader*, RpcHdr&, rpcstream&) ;
   static void receive_LOAD      (RpcReader*, RpcHdr&, rpcstream&) ;
   static void receive_BROWSE    (RpcReader*, RpcHdr&, rpcstream&) ;
   static void receive_TERMINATE (RpcReader*, RpcHdr&, rpcstream&) ;
} ;


#endif










