/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                  File: X_ide_spaceball_selection.c
 *                  Author: He, Taosong
 *                  Date: 1/19/93
 *           Description: The C routines of selection queue operations
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */


/******************************************************************/
/*                The standard C include file                     */
/******************************************************************/

#include <varargs.h>
#include <stdio.h>

/******************************************************************/
/*                  VolVis include file                           */
/******************************************************************/

#include "C_ide.h"
#include "MOTIF_windefs.h"

C_IDE_spaceball_lookup spaceball_lookup[C_MAX_OPERATION_NUMBER];

void C_generate_spaceball_map_common()
{
 extern C_ide_operation_map 
        rd_operation_map[C_MAX_RD_NUMBER][C_MAX_OPERATION_NUMBER];
 
 int i;
 for (i=0; i< C_MAX_OPERATION_NUMBER; i++)
  {
   spaceball_lookup[i].flag = 1; 
/*
   spaceball_lookup[i].type = SPACEBALL_PRESS;
*/
   switch (i)
       {
         case SPACEBALL_BUTPICK:
          spaceball_lookup[i].button = SPACEBALL_BUTPICK;
          sprintf(rd_operation_map[C_SPACEBALL][i].name, "%s", "Pick");
          break;
         case SPACEBALL_BUT1:
          spaceball_lookup[i].button = SPACEBALL_BUT1;
          sprintf(rd_operation_map[C_SPACEBALL][i].name, "%s", "button 1");
          break;
         case SPACEBALL_BUT2:
          spaceball_lookup[i].button = SPACEBALL_BUT2;
          sprintf(rd_operation_map[C_SPACEBALL][i].name, "%s", "button 2");
          break;
         case SPACEBALL_BUT3:
          spaceball_lookup[i].button = SPACEBALL_BUT3;
          sprintf(rd_operation_map[C_SPACEBALL][i].name, "%s", "button 3");
          break;
         case SPACEBALL_BUT4:
          spaceball_lookup[i].button = SPACEBALL_BUT4;
          sprintf(rd_operation_map[C_SPACEBALL][i].name, "%s", "button 4");
          break;
         case SPACEBALL_BUT5:
          spaceball_lookup[i].button = SPACEBALL_BUT5;
          sprintf(rd_operation_map[C_SPACEBALL][i].name, "%s", "button 5");
          break;
         case SPACEBALL_BUT6:
          spaceball_lookup[i].button = SPACEBALL_BUT6;
          sprintf(rd_operation_map[C_SPACEBALL][i].name, "%s", "button 6");
          break;
         case SPACEBALL_BUT7:
          spaceball_lookup[i].button = SPACEBALL_BUT7;
          sprintf(rd_operation_map[C_SPACEBALL][i].name, "%s", "button 7");
          break;
         case SPACEBALL_BUT8:
          spaceball_lookup[i].button = SPACEBALL_BUT8;
          sprintf(rd_operation_map[C_SPACEBALL][i].name, "%s", "button 8");
          break;
         default:
          spaceball_lookup[i].flag = -1;
          break;
       }
  }
}


void C_lookup_spaceball_op_map(event, operation_number)
XSpaceButEvent *event;
int *operation_number;
{
       int i;

       *operation_number = -1;

       for (i=0; i<C_MAX_OPERATION_NUMBER; i++)
        {
         if (spaceball_lookup[i].flag != -1)
          {
           if (spaceball_lookup[i].button == event->button)
            {
              *operation_number = i;
              break;
            }
          }
        }
}
         


