/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *                      File: MOTIF_popup_error.c
 *                    Author: Jiang(John) Qian
 *                      Date: 6/22/93
 *               Description: Creates a pop up error dialog, the user
 *			      has to click on the ok button inorder to 
 *			      proceed.
 *      Modification History:
 *
 *              Who?            When?           Why?
 *      --------------------------------------------------------------------
 *
 */

#include <Xm/RowColumn.h>
#include <Xm/MessageB.h>
#include <Xm/PushB.h>

#include "C_volvis.h"
#include "MOTIF_windefs.h"
#include "C_help.h"


extern Widget           vv_toplevel;
extern C_WindowDefs     window_defs;

/*
 *        Procedure Name: C_error_message
 *          Return Value: none
 *       Input Variables: message     - the message string to display
 *      Output Variables: none
 *      Update Variables: none
 *      Global Variables: vv_toplevel - the top level shell which is the 
 *					parent of error dialog.
 *			  window_defs -	used to set up colors.
 *
 *           Description: This function creates a error dialog.  It will
 *			  display the error message and an "ok" button is
 *			  created and the user has to click on it to proceed.
 */

void C_error_message(message)
char *message;		/* the error message to display */
{

  static Widget	  dialog = NULL;	/* the error dialog */
  Arg		  args[20];	
  int		  n;
  static int   	  return_value = 0; 
  extern XtAppContext     vv_app_context;

  /* create compound strings for labels */
  XmString ok, label;
  
  void button_callback();	/* callback when button is pressed */

	if (!dialog)
	{

   	    ok = XmStringCreateLtoR("OK", XmSTRING_DEFAULT_CHARSET), 
	    n = 0;
	    XtSetArg(args[n], XmNautoUnmanage, False);	      n++;
	    XtSetArg(args[n], XmNcancelLabelString, ok);	      n++;
            XtSetArg(args[n], XmNdialogStyle,
                                XmDIALOG_FULL_APPLICATION_MODAL); n++;
 
	    C_Set_Color_Dialog(args,n,window_defs);
	    dialog = XmCreateErrorDialog(vv_toplevel, "Error", args, n);

	    XtAddCallback(dialog, XmNcancelCallback, 
					  button_callback, &return_value);

	    /* do not display the ok and help button */
	    XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_OK_BUTTON));
	    XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
	    XmStringFree(ok);

	}
   	return_value = 0;
	
        label = XmStringCreateLtoR(message, XmSTRING_DEFAULT_CHARSET);

	n = 0;
	XtSetArg(args[n], XmNmessageString, label);		n++;
	XtSetValues(dialog, args, n);
        XmStringFree(label);

	XtManageChild(dialog);
	/* popup the dialog */
	XtPopup(XtParent(dialog), XtGrabNone);

	while (return_value == 0)
	    XtAppProcessEvent(vv_app_context, XtIMAll);

	XtPopdown(XtParent(dialog));
}


void  button_callback(dialog, client_data, cbs)
Widget dialog;
int *client_data;
XmAnyCallbackStruct *cbs;
{

	*client_data = 1;
}
