/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: MOTIF_mes_ui.c
 *		      Author: Lisa Sobierajski
 *			Date: 10/2/92
 *		 Description: Motif Message Windowing Routines Of VolVis
 *			      This file contains the routines for creating
 *			      the message window, and for displaying 
 *			      messages and error messages in that 
 *			      window.
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

/****			Standard C Includes   		****/
#include <stdio.h>

/****			X11 Includes			****/
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

/****			Motif Includes			****/
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/BulletinB.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/Frame.h>

/****			VolVis Includes			****/
#include "C_volvis.h"
#include "MOTIF_windefs.h"
#include "C_help.h"


/* Global Variables For Motif Windowing */
Widget			mes_text;
Dimension         	mes_width_so_far=0;


/*
 *        Procedure Name: mes_callback
 *          Return Value: void
 *       Input Variables: 
 *		
 *		w		-	The widget to which this callback
 *					is attached
 *		client_data     -	Unused
 *		call_data	-	Unused
 *
 *      Output Variables: none
 *      Update Variables: none
 *      Global Variables: 
 *
 *		mes_bbdialog    -	The Bulletin Board Dialog for the
 *					messages window      
 *
 *           Description:
 *		
 *		This routine is called when the messages button is
 *		pressed, and should not be called for any other reason.
 *		The mes_bbdialog variable is checked to see if the 
 *		message window has been created already.  If not, the
 *		message window is created.  If the message window exists,
 *		but is not managed (popped up on the display) then it is
 *		managed.  If the message window exists and is managed, it
 *		is unmanaged and then managed.  This causes the window to
 *		disappear and reappear (which will pop it to the top if
 *		it was burried under other windows)	
 */
void mes_callback( w, client_data, call_data )
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	/****		External Variables		****/
	extern Widget	  mes_bbdialog;	  	/* Bulletin Board Dialog */

	/****		Local Routines			****/
	void       	  create_mes_window();  /* Window Create Routine */

	/* Determine if the messages bboard dialog should be created */
	/* If mes_bbdialog does not exist, create it - otherwise if  */
	/* it is managed, unmanage it and then manage it (to pop it  */
	/* down and then pop it back up again so that the user can   */
	/* locate it.)  If it exists but is not managed, just manage */
	/* it.							     */
	if( !mes_bbdialog )
		create_mes_window();
	else 
	{
		if (XtIsManaged( mes_bbdialog) )
		{
			XtUnmanageChild( mes_bbdialog );
		}
		XtManageChild( mes_bbdialog );
	}
}


/*
 *        Procedure Name: create_mes_window
 *          Return Value: void
 *       Input Variables: none
 *      Output Variables: none
 *      Update Variables: none
 *      Global Variables: 
 *		
 *		vv_toplevel	-	The top level widget of VolVis
 *		mes_bbdialog	-	The bulletin board dialog for
 *					the message window which is to
 *					be created
 *		window_defs	-	Window appearance definitions
 *
 *           Description:
 *
 *		This routine is called once to create the mes_bbdialog
 *		(message window bulletin board dialog).  It is called
 *		from mes_callback if the messages button is pressed on
 *		the VolVis main window, or it is called from either
 *		C_message or C_error message if another routine attempts
 *		to display a message after the top level window has been
 *		created but before mes_bbdialog has been created.
 */
void create_mes_window()
{
	extern void	     close_callback();
	extern void	     help_callback();

	extern Widget	     vv_toplevel;  /* VolVis toplevel Shell Widget */
	extern Widget	     mes_bbdialog; /* Bulletin Board Dialog        */
	extern C_WindowDefs  window_defs;  /* widget colors                */
	
	Arg		     args[20];	   /* Argument List                */
	int		     n;		   /* Argument Count               */
	Widget		     frame;        /* The frame widget		   */
        Widget		     rowcolumn;    /* A rowcolumn for the buttons  */
	Widget		     button;	   /* A button widget		   */ 


	/* Create The Messages Bulletin Board */
	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 0 ); n++;
	XtSetArg( args[n], XmNautoUnmanage, False ); n++;
	XtSetArg( args[n], XmNnoResize, True ); n++;
	C_Set_Color_Dialog( args, n, window_defs );
	mes_bbdialog = XmCreateBulletinBoardDialog( vv_toplevel,
		       "Messages", args, n );

        n = 0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = XmCreateFrame( mes_bbdialog, "frame", args, n );
        XtManageChild( frame );

	/* Create The Scrolled Text Widget = Message Area */
	n=0;
	XtSetArg( args[n], XmNcolumns, 50 ); n++;
	XtSetArg( args[n], XmNrows, 10 ); n++;
	XtSetArg( args[n], XmNscrollVertical, True ); n++;
	XtSetArg( args[n], XmNscrollHorizontal, False ); n++;
	XtSetArg( args[n], XmNeditMode, XmMULTI_LINE_EDIT ); n++;
	XtSetArg( args[n], XmNvalue, "Welcome To VolVis\n" ); n++;
	C_Set_Color_Text( args, n, window_defs );
	mes_text = XmCreateScrolledText( frame, "mes_text", args, n );
	XtManageChild( mes_text );

        n = 0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 200 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = XmCreateFrame( mes_bbdialog, "frame", args, n );
        XtManageChild( frame );

        n = 0;
        C_Set_Color_RowColumn( args, n, window_defs );
	XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        rowcolumn = XmCreateRowColumn(frame, "rowcolumn", args, n);
        XtManageChild (rowcolumn);

        /************************************************/
        /*     Create The Close Button                  */
        /************************************************/
        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Close",
                xmPushButtonWidgetClass, rowcolumn, args, n );
        XtAddCallback( button, XmNactivateCallback,
                       close_callback, mes_bbdialog );
 
        /************************************************/
        /*     Create The Help Button                   */
        /************************************************/
        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Help",
                xmPushButtonWidgetClass, rowcolumn, args, n );
        XtAddCallback( button, XmNactivateCallback,
                       help_callback, C_MES_HELP );

	XtManageChild( mes_bbdialog );
}

void C_display_message( message )
char 		*message;
{
	extern C_WindowDefs	window_defs;

	int		  index;
	int		  loop;
	int	  	  mes_index;
	int		  bytes_read;
	char		  string[200];
	char		  one_line[200];
        Dimension         width;
        Dimension         width1;
        Dimension         width2;
        Dimension         width_so_far;
        Dimension         height1;
        Dimension         height2;
        XmString          string1;
        XmString          string2;
	XmTextPosition    curr_pos; 
	Arg		  args[1];

	width_so_far = mes_width_so_far;
 
        XtSetArg( args[0], XmNwidth, &width );
        XtGetValues( mes_text, args, 1 );
 
	index = 0;
	mes_index = 0;

	sscanf( &(message[mes_index]), "%s", string );
	bytes_read = strlen( string ) + 1;
	mes_index += bytes_read;
	while ( message[mes_index] == ' ' ) mes_index++;

	while ( bytes_read != 0 )
	{
            one_line[index] = '\0';
            string1 = XmStringCreate( one_line, XmSTRING_DEFAULT_CHARSET );
            XmStringExtent( window_defs.font_list, string1, &width1,
                            &height1 );
            string2 = XmStringCreate( string, XmSTRING_DEFAULT_CHARSET );
            XmStringExtent( window_defs.font_list, string2, &width2,
                            &height2 );

            if ( (width1 + width2 + width_so_far) > (width-25) )
            {
                    one_line[index++] = '\n';
                    one_line[index] = '\0';
                    curr_pos = XmTextGetLastPosition( mes_text );
                    XmTextInsert( mes_text, curr_pos, one_line );
                    index = 0;
                    for (loop=0; loop < strlen(string); loop++)
                            one_line[index++] = string[loop];
                    width_so_far = 0;
		    if ( width2 > (width-25) )
		    {
                        curr_pos = XmTextGetLastPosition( mes_text );
                        XmTextInsert( mes_text, curr_pos, string );
		    }
            }
            else   
            {
                    if ( index != 0 )
                            one_line[index++] = ' ';
                    for (loop=0; loop < strlen(string); loop++)
                            one_line[index++] = string[loop];
            }
            XmStringFree( string1 );
            XmStringFree( string2 );



	    if ( mes_index < strlen( message ) )
	    {
	        sscanf( &(message[mes_index]), "%s", string );
	        bytes_read = strlen(string) + 1;
	        mes_index += bytes_read;
		while ( message[mes_index] == ' ' ) mes_index++;
	    }
	    else	
		bytes_read = 0;
	}

        one_line[index] = '\0';
        string1 = XmStringCreate( one_line, XmSTRING_DEFAULT_CHARSET );
        XmStringExtent( window_defs.font_list, string1, &width1,
                        &height1 );
	width_so_far += width1;
        curr_pos = XmTextGetLastPosition( mes_text );
        XmTextInsert( mes_text, curr_pos, one_line );

	mes_width_so_far = width_so_far;

}

void C_part_message( message )
char		*message;
{
	extern Widget	  vv_toplevel;	  /* VolVis toplevel Shell Widget */
	extern Widget	  mes_bbdialog;	  /* Bulletin Board Dialog        */

	void		  C_display_message();

        XmTextPosition   position; 


	/* If the toplevel window doesn't exist, just print the message */
	if ( !vv_toplevel )
	{
		printf("%s",message);
		return;
	}


	/* Determine If The Messages Bboard Dialog Should Be Created */
	if( !mes_bbdialog )
		create_mes_window();

	C_display_message( message );

	position = XmTextGetLastPosition( mes_text );
	XmTextInsert( mes_text, position, " ");
	position = XmTextGetLastPosition( mes_text );
        XmTextShowPosition ( mes_text, position );
 
}

void C_message( message )
char		*message;
{
	extern Widget	  vv_toplevel;	  /* VolVis toplevel Shell Widget */
	extern Widget	  mes_bbdialog;	  /* Bulletin Board Dialog        */

	void		  C_display_message();

        XmTextPosition   position; 


	/* If the toplevel window doesn't exist, just print the message */
	if ( !vv_toplevel )
	{
		printf("%s\n",message);
		return;
	}


	/* Determine If The Messages Bboard Dialog Should Be Created */
	if( !mes_bbdialog )
		create_mes_window();

	C_display_message( message );

	position = XmTextGetLastPosition( mes_text );
	XmTextInsert( mes_text, position, "\n");
	position = XmTextGetLastPosition( mes_text );
        XmTextShowPosition ( mes_text, position );

	mes_width_so_far = 0;
 
}

/****
void C_error_message( message )
char		*message;
{
	extern Widget	  vv_toplevel;	  /* VolVis toplevel Shell Widget * /
	extern Widget	  mes_bbdialog;	  /* Bulletin Board Dialog        * /
	XmTextPosition    left, right;

	/* If the toplevel window doesn't exist, just print the message * /
	if ( !vv_toplevel )
	{
		printf("%s",message);
		return;
	}


	/* Determine If The Messages Bboard Dialog Should Be Created * /
	if( !mes_bbdialog )
		create_mes_window();

	left = XmTextGetLastPosition( mes_text );
	C_message( message );

	right = XmTextGetLastPosition( mes_text );

	XmTextSetHighlight( mes_text, left, right, 
			    XmHIGHLIGHT_SECONDARY_SELECTED );
}
*****/

