/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*                  File: C_ide_communication.c
/*                  File: MOTIF_ide_token.c
 *                Author: He, Taosong
 *                  Date: 1/18/93
 *           Description: MOTIF  routines for tokenizer
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */


#include <stdio.h>
#include <termio.h>
#include <malloc.h>
#include <fcntl.h>
#include <signal.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <signal.h>

#include "C_ide.h"
#include "C_volvis.h"

int ide_data_pipeline[C_MAX_RD_NUMBER][2];

int ide_selection_pipeline[2];

int ide_start_end_pipeline[2];

C_IDE_token ide_data_token[C_MAX_RD_NUMBER];

void C_ide_get_data(device, token)
int device;
C_IDE_token *token;
{
   read(ide_data_pipeline[device][0], token, sizeof(C_IDE_token));
   write(ide_data_pipeline[device][1], token, sizeof(C_IDE_token));
}

void C_ide_write_pipeline(device)
int device;
{
   C_IDE_token temp_token;
   
   read(ide_data_pipeline[device][0], &temp_token, sizeof(C_IDE_token));
   write(ide_data_pipeline[device][1], &ide_data_token[device], 
         sizeof(C_IDE_token));
}

static void initialize_data_pipeline(pipeline, device_number)
int *pipeline;
int device_number;
{
   extern C_identity3D();

   C_IDE_token temp_token;

   C_identity3D(&(temp_token.rotation));

   if ( (device_number == C_MOUSE) || (device_number == C_SPACEBALL) )
      {
       write(pipeline[1], &temp_token, sizeof(C_IDE_token));
       read(pipeline[0], &temp_token, 5000);
       write(pipeline[1], &temp_token, sizeof(C_IDE_token));
      }
}

void C_ide_open_pipeline()
{
    int device_number;
    int temp;

     for (device_number = 0; device_number< C_MAX_RD_NUMBER; device_number++)
        {
            if (pipe(ide_data_pipeline[device_number]) < 0)
             {
                printf("can not open device pipeline\n");
                exit(0);
             }
            initialize_data_pipeline(ide_data_pipeline[device_number], 
                                         device_number);
        }

      if (pipe(ide_selection_pipeline) < 0)
        {
                printf("can not open device pipeline\n");
                exit(C_ERROR);
         }
    temp = -1;
    write (ide_selection_pipeline[1], &temp, sizeof(int));

      if (pipe(ide_start_end_pipeline) < 0)
        {
               printf("can not open device pipeline\n");
               exit(C_ERROR);
        }
    temp = -1;
    write (ide_start_end_pipeline[1], &temp, sizeof(int));
}


void ide_parent_wait_process()
{
  int temp;

  temp = -1;

  while (temp != 1)
   {
    read(ide_start_end_pipeline[0], &temp, sizeof(int));
    write(ide_start_end_pipeline[1], &temp, sizeof(int));
   }

}

void exit_ide_process()
{

   int temp;

   int stop;

   stop = 0;

   read(ide_start_end_pipeline[0], &temp, 5000);

   temp = 2;
   write(ide_start_end_pipeline[1], &temp, sizeof(int));
   while (!stop)
    {
      read(ide_start_end_pipeline[0], &temp, sizeof(int));
      if (temp == 3) {
       temp = -1;
       stop=1;
                     }
      else
       temp = 2;
      write(ide_start_end_pipeline[1], &temp, sizeof(int));
    }

   exit(0);
}




