/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: C_ani_rotation.c
 *		      Author: Rick Avila 
 *			Date: 7/19/93
 *		 Description: Animation Rotation Routines
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <math.h>

#include "C_volvis.h"

/* Create an animation where the objects rotate about the X, Y, or Z 	*/
void ani_rotate( axis, steps, angle )
C_AxisType	axis;
int		steps;
float		angle;
{
	int		frame;
	int		vol_num;
	char		file_name[C_MAX_STRING];
	C_Volume	*volume;
	C_FPosition	object_center;
	C_Image		*image;

	extern C_View	view;
	extern C_World	world;

	if( world.num_volumes == 0 )
	{
		C_error_message("There isn't anything to project!!\n");
		return;
	}

	image = C_New( C_Image );
	C_create_image_from_view( image, &view );

	for( frame=0; frame < steps; frame++ )
	{
	   for( vol_num=0; vol_num<world.num_volumes; vol_num++ )
	   {
		volume =  world.volume[vol_num];

		if( volume->visible && volume->modifiable )
		{
			object_center.x = volume->x_size_units / 2.0;
			object_center.y = volume->y_size_units / 2.0;
			object_center.z = volume->z_size_units / 2.0;

			C_rotate_volume_world( volume, axis, 
				C_Deg_To_Rad(angle), &object_center );

			C_create_volume_matrices( volume );
		}
	   }

	   C_update_system( C_VOLUME_MODIFIED );

	   switch( view.projection_type )
	   {
		case C_PARC:
			C_cast_rays(&world, &view, image, TRUE);
			break;
		case C_RAY_TRACE:
			C_cast_rays(&world, &view, image, FALSE);
			break;
		case C_VOLRAD:
			break;
	   }

	   sprintf( file_name, "data/ANI/ani.%d.img", frame );
	   C_write_image_to_file( image, file_name );

	}
}

