/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                  File: My_C_Volvis.h
 *                Author: Theodossiou, Andreas
 *                  Date: 05/11/1993
 *           Description: Constants and typedefs
 *  Modification History:
 *
 *         who?               when?           why?
 *    -----------------------------------------------------------
 *
 */

/* Global constants */

#define C_MAX_SELECTION_NO 20
#define BUTTON_WIDTH 150
#define C_MAX_SELECTION_WIDGETS 8
#define C_MAX_OPERATION_NUMBER  10
#define C_MAX_DEVICE     10
#define C_MAX_NAME_LENGTH  30

/* Mouse constants */

#define C_MOUSE_MAX_MODE   2
#define C_MOUSE_MAX_UNIT   2
#define C_MOUSE_MAX_LABELS 3
#define C_MAX_TRANS        1
#define C_MAX_ROT          3
#define C_MAX_TRANS_ROT    1
#define C_SCREEN           0
#define C_WINDOW           1
#define C_PIXEL            0
#define C_NORMALIZED       1
#define C_Traid_Mouse      0
#define C_Trackball        0
#define C_Arcball          1
#define C_Slides           2
#define C_Manual           0

/* Spaceball constants */

#define C_SPACEBALL_MAX_LABELS 7
#define C_MAX_VIEWM     5
#define C_MAX_TRANSM    5
#define C_MAX_ROTM      4
#define C_MAX_VCRM      3
#define C_MAX_VCRLOOPM  3
#define C_Object        0
#define C_Eyepoint      1
#define C_Orbit         2
#define C_Orbit_Direction 3
#define C_Pullthru      4
#define C_Trans_Off     0
#define C_Trans_Dominant 1
#define C_Trans_On      2
#define C_Trans_Z_Only  3
#define C_Super_Dominant 4
#define C_Rot_Off 0
#define C_Rot_Dominant 1
#define C_Rot_On 2
#define C_R_Super_Dominant 3  /* name clash with above */
#define C_Recording 0
#define C_Stopped 1
#define C_Playing 2
#define C_One_Play 0
#define C_Repeat 1
#define C_Bounce 2
#define C_MAX_VCRTAPE_NAME 10
#define C_MAX_DIR_NAME     128

/* Isotrak constants */

#define C_ISOTRAK_MAX_LABELS 6
#define C_MAX_ALLIGNMENT     2
#define C_MAX_BORESIGHT      2
#define C_MAX_ENVELOPE       1
#define C_MAX_FORMAT         2
#define C_MAX_HEMISPHERE     1

/* DataGlove constants */

#define C_MAX_USER_PORTS     18
#define C_MAX_SENSOR_NUMBER  10
#define C_MAX_COMMANDS       20
#define C_MAX_BAUD_RATE      6
#define C_Repeat_60          0
#define C_Repeat_30          1
#define C_One_Shot           2
#define C_Set_Angle_Output   3
#define C_Set_Flex_Output    4
#define C_UserRead           5
#define C_Write_To_User_Port 6
#define C_Load_Table         7
#define C_QUIT               8
#define C_Set_LED_Level      9
#define C_Read_LED_Level     10
#define C_SystemID           11
#define C_ColdReset          12
#define C_WarmReset          13
#define C_UserIRQ            14
#define C_Send_to_Polhemus   15
#define C_Set_Polhemus_units 16
#define C_Number_of_sensors  17
#define C_Load_Calibration   18
#define C_Load_Gestures      19
#define SET 0
#define NOT_SET 1
#define DISABLED 0
#define ENABLED 1

/* Mouse simulation data type */
typedef struct {
    int                             trans_simu; 
    int                             rot_simu;
    int                             trans_rot_simu;
    int                             simulate_switch_simu;
    int                             mode_simu;
    int                             unit_simu;
    } mouse_simulation;

/* Spaceball simulation data type */ 
typedef struct {
    int                 view_simu;
    int                 trans_simu;
    int                 rot_simu;
    int                 vcr_simu;
    int                 vcr_loop_simu;
    char                tape_name_simu[C_MAX_VCRTAPE_NAME];
    char                tape_dir_simu[C_MAX_DIR_NAME];
} spaceball_simulation;

/* Isotrak simulation data type */
typedef struct {
    int        allignment_simu;
    int        boresight_simu;
    int        envelope_simu;
    int        format_simu;
    int        hemisphere_simu;
    float      increment_simu;
} isotrak_simulation;


/* Repeat60, Repeat30, OneShot data type */
typedef struct {
   int Flex;
   int Polhemus;
   int Gesture;
} Repeat_or_One_Shot;

/* Load Table data type */
typedef struct {
    int joint;
    int translation[256];
} Load_Table;

/* Polhemus units data type  */
typedef enum {Inches,Centimeters,Raw} PolhemusUnits;

/* Send to Polhemus data type */
typedef struct {
    int max_index;
    int *decimal_equivalents;
} Send_to_Polhemus;

/* Dataglove commands data type */
typedef struct {
    Repeat_or_One_Shot Repeat60;
    Repeat_or_One_Shot Repeat30;
    Repeat_or_One_Shot OneShot;
    int                SetAngleOutput;
    int                SetFlexOutput;
    /*                 UserRead; */
    int                WritetoUserPort;
    Load_Table         LoadTable;
    /*                 QUIT; */
    int                SetLEDLevel;
    /*                 ReadLEDLevel; */
    /*                 SystemID; */
    /*                 ColdReset; */
    /*                 WarmReset; */
    int                UserIRQ;
    Send_to_Polhemus   SendtoPolhemus;
    PolhemusUnits      SetPolhemusUnits;
    int                NumberofSensors;
    char*              LoadCalibration;
    char*              LoadGestures;
    int                BaudRates;
} dataglove_simulation;

/* Data type to keep track of all the input devices */
typedef struct {
    mouse_simulation     mouse;
    spaceball_simulation spaceball;
    isotrak_simulation   isotrak;
    dataglove_simulation dataglove;
} C_IDE_simulation_method;


/* Operation map stuff....*/  

/*
typedef struct {
    int selection_number;
    int device_name;
    int device_operation_number;
} selection_map;

selection_map C_ide_selection[C_MAX_SELECTION_NUMBER];

typedef char Device_operation_map[C_MAX_NAME_LENGTH];

Device_operation_map device_operation_array[C_MAX_DEVICE][C_MAX_OPERATION_NUMBER];

*/

typedef Widget Open_Selection_Maps[C_MAX_SELECTION_WIDGETS][3*C_MAX_SELECTION_NO];
