/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *			File: C_help.h
 *		      Author: Lisa Sobierajski
 *			Date: 6/13/93 
 *		 Description: Help Constants Of VolVis
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */
 
#define C_HELP_PATH			      	"help"
#define C_HIGHLIGHT_TOKEN		      	"##"
#define C_TAG_TOKEN                     	"@@"
#define C_MAX_MORE_HELP_ENTRIES         	100


 
#define C_NUM_HELP_OPTIONS		45	

typedef enum
{
       	C_ANI_FLIGHT_HELP,
       	C_ANI_HELP,
       	C_ANI_MANUAL_HELP,
       	C_ANI_VIEW_HELP,
	C_FIO_HELP,
       	C_FIO_LOAD_HELP,
       	C_FIO_SAVE_HELP,
	C_HLP_HELP,
        C_IDE_CONFIGURATION_HELP,
       	C_IDE_HELP,
        C_IDE_PANEL_HELP,
        C_IDE_RD_MOUSE_HELP,
        C_IDE_RD_SPACEBALL_HELP,
        C_IDE_RD_KEYBOARD_HELP,
        C_IDE_RD_MAP_HELP,
        C_IDE_SELECTION_HELP,
        C_IDE_VD_HELP,
       	C_IVI_HELP,
       	C_MEA_HELP,
       	C_MES_HELP,
       	C_NAV_HELP,
       	C_NAV_MANUAL_HELP,
       	C_NAV_PROJECTION_HELP,
       	C_NAV_PROJECTION_OPTIONS_HELP,
       	C_NAV_WIREFRAME_HELP,
       	C_OCO_CONTROL_HELP,
       	C_OCO_CREATE_HELP,
       	C_OCO_CREATE_GEO_HELP,
       	C_OCO_CREATE_LIGHT_HELP,
       	C_OCO_HELP,
       	C_OCO_MODIFY_LIGHT_HELP,
       	C_OCO_MODIFY_VIEW_HELP,
       	C_OCO_MODIFY_VOLUME_COLOR_HELP,
       	C_OCO_MODIFY_VOLUME_DATA_HELP,
       	C_OCO_MODIFY_VOLUME_HELP,
       	C_OCO_MODIFY_VOLUME_SHADE_HELP,
       	C_OCO_MODIFY_VOLUME_TEXTURE_HELP,
       	C_OCO_MODIFY_WORLD_HELP,
       	C_OCO_VOLUME_X_SLICES_HELP,
       	C_OCO_VOLUME_Y_SLICES_HELP,
       	C_OCO_VOLUME_Z_SLICES_HELP,
       	C_PRE_HELP,
       	C_REN_HELP,
       	C_REN_SETUP_HELP
} C_HelpType;


typedef struct
{
        XmTextPosition  left;
        XmTextPosition  right;
        char            *help_file;
        int             tag;
} C_MoreHelpEntry;


typedef struct
{
        int                     num_entries;
        C_MoreHelpEntry         entry[C_MAX_MORE_HELP_ENTRIES];
} C_MoreHelpInfo;


