#include <stdio.h>
#include "vort.h"

/*
 * writemappedline
 *
 *	writes a scanline of colour map indexes from line to file out.
 */
int
writemappedline(out, line)
	image		*out;
	unsigned char	*line;
{
	register int	x;
	unsigned char	indx, i, run, count, lbuf[127];

	switch (imagetype(out)) {
	case PIX_CMAP:
		for (x = 0; x < imagewidth(out); x++)
			if (writebyte(out, line[x]) == EOF)
				return(0);
		break;
	case PIX_RLECMAP:
		indx = line[0];
		count = 0;
		run = 0;
		for (x = 1; x < imagewidth(out); x++) {
			if (indx != line[x]) {
				if (run != 0) {
					if (writebyte(out, run) == EOF)
						return(0);
					writebyte(out, indx);
					run = 0;
				} else {
					if (count == 127) {
						if (writebyte(out, 255) == EOF)
							return(0);
						for (i = 0; i != 127; i++)
							writebyte(out, lbuf[i]);
						count = 0;
					}
					lbuf[count] = indx;
					count++;
				}
			} else if (run == 127) {
				if (writebyte(out, 127) == EOF)
					return(0);
				writebyte(out, indx);
				run = 0;
			} else {
				if (count != 0) {
					if (writebyte(out, count | 0x80) == EOF)
						return(0);
					for (i = 0; i != count; i++)
						writebyte(out, lbuf[i]);
					count = 0;
				}
				run++;
			}
			indx = line[x];
		}
		if (count != 0) {
			if (writebyte(out, count | 0x80) == EOF)
				return(0);
			for (i = 0; i != count; i++)
				writebyte(out, lbuf[i]);
		}

		if (writebyte(out, run) == EOF)
			return(0);
		writebyte(out, indx);
		break;
	default:
		fprintf(stderr, "writemappedline: bad file format.\n");
		return(0);
	}

	return(1);
}
