#include <math.h>
#include <stdio.h>
#include "art.h"
#include "macro.h"
#include "gram.h"
#include "poly.h"

extern mats	*mstackp;
extern hlist	*fhlist;
extern float	tolerance;

extern double	power();

/*
 * bounding box for all superquadrics
 */
static bbox sqbox = {
	{ 1.0, 1.0, 1.0 },
	{ -1.0, -1.0, -1.0 }
};

/*
 * superinit
 *
 *	initialise the function pointers and fields for a superquadric object,
 * 	returning its pointer.
 */
void
superinit(o, d)
	object	*o;
	details *d;
{
	superquadric	*sprq;
	int		first, order;
	vector		c1, c2, cent;
	float		xlen, ylen, zlen;
	details		*ld;

	first = 1;

	order = 1;
	c1.x = c1.y = c1.z = -1.0;
	c2.x = c2.y = c2.z = 1.0;

	while (d != (details *)NULL) {
		switch (d->type) {
		case VERTEX:
			if (first) {
				c1 = d->u.v;
				first = 0;
			} else
				c2 = d->u.v;
			break;
		case ORDER:
			order = d->u.i;
			break;
		default:
			warning("art: illegal field in superquadric ignored.\n");
		}
		ld = d;
		d = d->nxt;
		free(ld);
	}

	xlen = fabs((c1.x - c2.x)) / 2;
	ylen = fabs((c1.y - c2.y)) / 2;
	zlen = fabs((c1.z - c2.z)) / 2;

	cent.x = (c1.x + c2.x) / 2.0;
	cent.y = (c1.y + c2.y) / 2.0;
	cent.z = (c1.z + c2.z) / 2.0;

	if (order == 1) {		/* a diamond */
		pushmatrix();

			calctransforms(mstackp);
			multmatrix(mstackp->obj2ray);

			translate(cent.x, cent.y, cent.z);

			move(xlen, 0.0, 0.0);	/* "equator" */
			draw(0.0, ylen, 0.0);
			draw(-xlen, 0.0, 0.0);
			draw(0.0, -ylen, 0.0);
			draw(xlen, 0.0, 0.0);

			move(0.0, 0.0, zlen);	/* upper latitude */
			draw(0.0, ylen, 0.0);

			move(0.0, 0.0, zlen);
			draw(-xlen, 0.0, 0.0);

			move(0.0, 0.0, zlen);
			draw(0.0, -ylen, 0.0);

			move(0.0, 0.0, zlen);
			draw(xlen, 0.0, 0.0);

			move(0.0, 0.0, -zlen);	/* lower latitude */
			draw(0.0, ylen, 0.0);

			move(0.0, 0.0, -zlen);
			draw(-xlen, 0.0, 0.0);

			move(0.0, 0.0, -zlen);
			draw(0.0, -ylen, 0.0);

			move(0.0, 0.0, -zlen);
			draw(xlen, 0.0, 0.0);

		popmatrix();
	} else {			/* just do a box for now */
		pushmatrix();

			calctransforms(mstackp);
			multmatrix(mstackp->obj2ray);

			move(c1.x, c1.y, c1.z);
			draw(c2.x, c1.y, c1.z);
			draw(c2.x, c2.y, c1.z);
			draw(c1.x, c2.y, c1.z);
			draw(c1.x, c1.y, c1.z);

			move(c1.x, c1.y, c2.z);
			draw(c2.x, c1.y, c2.z);
			draw(c2.x, c2.y, c2.z);
			draw(c1.x, c2.y, c2.z);
			draw(c1.x, c1.y, c2.z);

			move(c1.x, c1.y, c2.z);
			draw(c1.x, c1.y, c1.z);

			move(c2.x, c2.y, c2.z);
			draw(c2.x, c2.y, c1.z);

			move(c1.x, c2.y, c2.z);
			draw(c1.x, c2.y, c1.z);

			move(c2.x, c1.y, c2.z);
			draw(c2.x, c1.y, c1.z);
		
		popmatrix();
	}
}
