/*
 * Copyright (c) 1990,1,2 Mark Nitzberg
 * and President and Fellows of Harvard College
 * All rights reserved.
 * 
 * simple vector stuff -- could be much better
 */
#include "vector.h"

#define X(v) (v).x
#define Y(v) (v).y

/*
 * a vector
 */
vector
v_vec(x, y)
float   x, y;
{
    vector  v;

    X(v) = x;
    Y(v) = y;
    return v;
}

/*
 * angle between v based at 0 and x axis
 */
float
v_angle(v)
vector  v;
{
    double  atan2();

    return atan2(Y(v), X(v));
}

/*
 * sum:  v1+v2
 */
vector
v_sum(v1, v2)
vector  v1, v2;
{
    vector  v;

    X(v) = X(v2) + X(v1);
    Y(v) = Y(v2) + Y(v1);
    return v;
}

/*
 * difference:  v2-v1
 */
vector
v_difference(v1, v2)
vector  v1, v2;
{
    vector  v;

    X(v) = X(v2) - X(v1);
    Y(v) = Y(v2) - Y(v1);
    return v;
}

/*
 * perpendicular (pi/2 rotation)
 */
vector
v_perp(v)
vector  v;
{
    vector  perp;

    X(perp) = -Y(v);
    Y(perp) = X(v);
    return perp;
}

/*
 * multiply by scalar
 */
vector
v_scalar_mult(c, v)
float   c;
vector  v;
{
    X(v) *= c;
    Y(v) *= c;
    return v;
}

/*
 * v_norm squared
 */
float
v_normsq(v)
vector  v;
{
    return (X(v) * X(v) + Y(v) * Y(v));
}

/*
 * distance squared between points
 */
float
v_distsq(onepoint, another)
vector  onepoint, another;
{
    return v_normsq(v_difference(onepoint, another));
}

/*
 * distance between points
 */
float
v_distance(onepoint, another)
vector  onepoint, another;
{
    return v_norm(v_difference(onepoint, another));
}

/*
 * dot product
 */
float
v_dot(v1, v2)
vector  v1, v2;
{
    return (X(v1) * X(v2) + Y(v1) * Y(v2));
}
