/**************************************************************************
*                rxbm.c                                                   *
*                                                                         *
*  Copyright (C) 1995 by Heikki Tienari. See tis.doc for more info.       *
*                                                                         *
*  This module contains the code to read the XBM file format.             *
*                                                                         *
**************************************************************************/
/* 190295 -HT- Works                                            * 
*  250395 -HT- Result is now returned if an error may occurs.   *
*  160595 -HT- Makefile support.                                *
*/

#include <math.h>
#include <stdio.h>
#include "image.h"

Read_XBM_Image( Image, name )
struct Image_Struct *Image;
char *name;
{
  unsigned int Width, Height;
  unsigned char *data, *map_line;
  int x_hot, y_hot;
  int x, y, i;

  if( XReadBitmapFileData( name, &Width, &Height, &data, &x_hot, &y_hot) ) {
    printf("Cannot read bitmap file %s.\n", name );
    return(1);
    }

  /* Let's mallocate some memory. */
  if( (Image->Colour_Map=(IMAGE_COLOUR *)malloc(2 * sizeof(IMAGE_COLOUR)))==NULL ) {
      printf("Failed to allocate memory for Color Map.\n");
      return(2);
      }
  Image->Colour_Map[0].Red=255;
  Image->Colour_Map[0].Green=255;
  Image->Colour_Map[0].Blue=255;
  Image->Colour_Map[1].Red=0;
  Image->Colour_Map[1].Green=0;
  Image->Colour_Map[1].Blue=0;
  if( (Image->data.map_lines = (unsigned char **)
       malloc(Height * sizeof(unsigned char *)))==NULL ) {
    printf("Failed to allocate memory for Image Data.\n");
    return(2);
    }
  for( i=0; i<Height; i++ )
    {
    if( (map_line=(unsigned char *)malloc(Width*sizeof(unsigned char)))==NULL ) {
      printf("Failed to allocate memory for Image Data.\n");
      return(2);
      }
    Image->data.map_lines[i] = map_line;
    }

  for( y=0; y<Height; y++ )
    for( x=0; x<(int)ceil((float)Width/8.0); x++ )
      for( i=0; i<8; i++ )
        if( data[y*(int)ceil((float)Width/8.0)+x]&1<<i )
          Image->data.map_lines[y][x*8+i]=1;
        else
          Image->data.map_lines[y][x*8+i]=0;

  Image->Colour_Map_Size=2;
  Image->width = Width;
  Image->height = Height;

  XFree( data );

  return(0);
}
