#import "aGroup-inter.h"
#import "aGroup.h"
#import "pg.h"

@implementation pg
- defaultConfig
{
  [self noAngleSetup];
  return self;
}

- clip: (NXCoord) x: (NXCoord) y 
{ 
  PSmoveto(x,y);
  PSrectclip(0,0,genw,genh);
  return self;
}

- resizeGenerator
{
  genh = latticesize.height = bounds.size.height;
  genw = bounds.size.width;
  latticesize.width = 2 * genw;
  upx = 0;
  upy = latticesize.height;
  overx = latticesize.width;
  gravy = upy/2;
  gravx = upx/2;
  return self;
}

- makeLatticeUnitAt: (NXPoint *) point fromImage: srcimg 
{
  id imgrep;
  NXPoint pt;
  
  pt.x = - point->x ;
  pt.y = - point->y ;
  imgrep = [srcimg bestRepresentation];
  PSgsave();
  [self clip:0.0:0.0];
  [imgrep drawAt: &pt];
  PSgrestore();
  PSgsave();
  reflect(0.0);
  PStranslate(bounds.size.width,-bounds.size.height);
  [self clip:0.0:0.0];
  [imgrep drawAt: &pt];
  PSgrestore();
  return self;
}
@end
