#import "p3.h"

@implementation p3
- defaultConfig
{
  [self noAngleSetup];
  return self;
}

- resizeGenerator
{
  latticesize.height = 3.0 * bounds.size.height / 2.0;
  latticesize.width = bounds.size.width * 2;
  upx = bounds.size.width;
  upy = bounds.size.height;
  overx = latticesize.width;
  return self;
}

- clip: (NXCoord) x: (NXCoord) y 
{ 
  PSnewpath();
  PSmoveto(x,y);
  PSrmoveto(0,bounds.size.height/3.0);
  PSrlineto(0, 2 * bounds.size.height / 3.0);
  PSrlineto(bounds.size.width,-bounds.size.height/3.0);
  PSrlineto(0,2.0 * -bounds.size.height /3.0);
  PSclosepath();
  PSclip();
  return self;
}

- makeLatticeUnitAt: (NXPoint *) point fromImage: srcimg 
{
  id imgrep;
  int i;
  NXPoint pt;
  
  pt.x = - point->x ;
  pt.y = - point->y ;
  imgrep = [srcimg bestRepresentation];
  for(i=0;i<3;i++){
    PSgsave();
    PStranslate(0,bounds.size.height/3);
    PSrotate(120*i);
    PStranslate(0,-bounds.size.height/3);
    [self clip:0.0:0.0];
    [imgrep drawAt: &pt];
    PSgrestore();
  }
  return self;
}
- (BOOL)isRigidLattice { return YES; };
- sizeKludge: (float *) x : (float *) y
{
  float hyp;

  hyp = *y / 3.0 * 2.0;
  *x = [self equi: hyp];
  return self;
}

- (float)equi: (float) side
{
  return sqrt(3)/2 * side;
}

@end
