/* image.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#include <stdio.h>
#include <math.h>
#include <scry_anima.h>
#include <scry_image.h>
#include <scry_client.h>
#include <scry_limits.h>

unsigned char S_map[S_MAX_COL_SIZE][3] ;    /* color map */
int S_mapnum ;		/* number of entries in color map */
int S_maxcol ;		/* max number of entries */

struct image_stuff S_image_info ;	/* information for image transfer */

char anima_format[80] ;		/* either "one map" or "many map" */


/* display_frame:    transfer a frame to the server and display it
   xdr_image_info:   XDR encode and transfer image information to server
   sc_get_info:      get server display information
   xdr_visin:        XDR decode server display information */


/* transfer a frame (image in an Anima sequence) to the server
   and display it */

display_frame(current)

int current ;	/* index into sequence of frames */

{
    register int i, j;
    bool_t xdr_image_info();        /* XDR encodes frame information */
    int height, width ;
    enum clnt_stat err ;
    unsigned char *shrink_ccc();    /* truncates the image to server size */
    int changed = 0 ;	/* if true, have had to truncate the compressed image */

#ifdef LATER
    fprintf (stderr,"%d ",current) ;
#endif
        /* if recording */
    if (S_image_info.s_recordable != S_PREVIEW)
	    /* update frame number */
	sc_set_frame(1) ;
    fseek(S_anima_file, 0, 0) ;
	/* read image header */
    if(!iff_read_header(S_anima_file, &S_image_info, &height, &width,anima_format))
        fprintf(stderr,"couldn't read image header\n");
    if ((S_image_info.c_height != height) || (S_image_info.c_width != width))
	/* if image size has changed */
    {
        S_image_info.c_height = height ;
        S_image_info.c_width = width ;
	    /* reallocate pixel data */
        if (S_image_info.data != NULL)
            free(S_image_info.data) ;
        S_image_info.data = (unsigned char *) malloc(S_image_info.c_height * S_image_info.c_width / 2) ;
    }
	/* seek to current frame information */
    fseek(S_anima_file, S_a_index[current].offset, 0);

	/* if header stored for each frame, or first frame in file */ 
    if ((anima_format[0] == 'm') || (current == 0))
    {
	    /* read image header */
        if(!iff_read_header(S_anima_file, &S_image_info, &height, &width,anima_format))
	    fprintf(stderr,"couldn't read image header\n");
    
	    /* if image size has changed */
        if ((S_image_info.c_height != height) || (S_image_info.c_width != width))
        {
            S_image_info.c_height = height ;
            S_image_info.c_width = width ;
		/* reallocate pixel data storage */
	    if (S_image_info.data != NULL)
	        free(S_image_info.data) ;
	    S_image_info.data = (unsigned char *) malloc(S_image_info.c_height * S_image_info.c_width / 2) ;
        }
    }
	/* total bytes in compressed image */
    S_image_info.total = S_a_index[current].buf_total ;
	/* read compressed image */
    iff_read_buf(S_anima_file, &S_image_info);
         /* safest choices */
    S_image_info.c_depth = 3 ;
    S_image_info.compression = 1 ;
	/* if image larger than server display */
    if ((S_image_info.s_height < S_image_info.c_height) ||
	(S_image_info.s_width < S_image_info.s_width))
    {
	    /* truncates image to server display size */
        S_image_info.data = shrink_ccc(S_image_info.data,S_image_info.c_height,
		       S_image_info.c_width, S_image_info.s_height,
		       S_image_info.s_width, &S_image_info.total) ;
        changed = 1 ;
	    /* update image height and width */
        if (S_image_info.s_height < S_image_info.c_height)
            S_image_info.c_height = S_image_info.s_height ;
        if (S_image_info.s_width < S_image_info.c_width)
            S_image_info.c_width = S_image_info.s_width ;
    }

    S_during_rpc = 1 ;
        /* transmit image to server, display, and optionally record */
    if ((int) (err = clnt_call(S_client,S_DISPLAYPROC,xdr_image_info,&S_image_info,
                         xdr_void,(char *) 0,S_total_timeout)) != 0)
        {
            clnt_perrno ((int) err) ;
            fprintf (stderr,"can't make DISPLAYPROC call\n") ;
            clnt_destroy (S_client) ;
            exit (-1) ;
        }
    S_during_rpc = 0 ;
    if (S_make_closing_call)
	scry_abn_exit() ;
    if (changed)
    {
	S_image_info.c_height = height ;
	S_image_info.c_width = width ;
    }
}




/* XDR encode and transfer image information to server */

bool_t 
xdr_image_info (xdrsp,image_info)

XDR *xdrsp ;			/* XDR handle */
struct image_stuff *image_info ;	/* frame buffer and control information */

{
    int i ;
    int total = 0 ;

        /* for compatibility with Scry client */
        /* current frame in Anima file, if saving */
    if (!xdr_long(xdrsp,&image_info->current_frame_to_save))
        return (0) ;
            /* total frames in Anima file, if saving */
    if (!xdr_long(xdrsp,&image_info->total_frames))
        return (0) ;
            /* compression type */
    if (!xdr_int(xdrsp,&image_info->compression))
	return (0) ;
    total = image_info->total ;
#ifdef DEBUG
    printf ("total = %d\n",total) ;
#endif
	/* total bytes in compressed image */
    if (!xdr_int(xdrsp,&image_info->total))
	return (0) ;
	    /* image height */
    if (!xdr_int(xdrsp,&image_info->c_height))
	return (0) ;
	    /* image width */
    if (!xdr_int(xdrsp,&image_info->c_width))
	return (0) ;
	    /* color depth in bytes */
    if (!xdr_int(xdrsp,&image_info->c_depth))
	return (0) ;
    if (image_info->compression & S_LEMPEL_ZIV)
                /* total bytes after further (Lempel-Ziv) compression */
        if (!xdr_int(xdrsp,&image_info->total_lz))
	    return (0) ;
    if (!xdr_int(xdrsp,&(image_info->in_at)))  /* start recording at */
	    return (0) ;
    if (!xdr_int(xdrsp,&(image_info->out_at))) /* finish recording at */
	    return (0) ;
    if (image_info->compression & S_LEMPEL_ZIV)
                /* total number of bytes if Lempel-Ziv compression was used */
        total = image_info->total_lz ;
    else
        total = image_info->total;
	    /* color map */
    if ((image_info->compression != S_NONE) && (image_info->compression != S_LEMPEL_ZIV))
    {
	if (!xdr_int(xdrsp,&(S_mapnum)))
		return (0) ;
        if (!xdr_opaque(xdrsp,S_map,S_mapnum*3))
	    return (0) ;
    }
            /* send compressed frame buffer */
    if (!xdr_opaque(xdrsp,image_info->data,total))
	return (0) ;
    return (1) ;
}




/* get server display information */

sc_get_info()

{
    enum clnt_stat err ;
    bool_t xdr_visin() ;

    S_during_rpc = 1 ;
    if ((int) (err = clnt_call(S_client,S_VISPROC,xdr_void,(char *)0,
			 xdr_visin,&S_image_info,S_total_timeout)) != 0)
    {
        clnt_perrno ((int) err) ;
        fprintf (stderr,"can't make S_VISPROC call\n") ;
        clnt_destroy (S_client) ;
        return ;
    }
    S_during_rpc = 0 ;
    if (S_make_closing_call)
	scry_abn_exit() ;
}




/* XDR decode server display information */

bool_t 
xdr_visin (xdrsp,image_info)

XDR *xdrsp ;		/* XDR handle */
struct image_stuff *image_info ;

{
	    /* color resolution of server display in bytes */
    if (!xdr_int(xdrsp,&(image_info->s_depth)))
	return (0) ;
	    /* server display height */
    if (!xdr_int(xdrsp,&(image_info->s_height)))
	return (0) ;
	    /* server display width */
    if (!xdr_int(xdrsp,&(image_info->s_width)))
	return (0) ;
	    /* whether possible to do video recording on server */
    if (!xdr_int(xdrsp,&(image_info->s_recordable)))
	return (0) ;
    return(1) ;
}
