/* movie.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

#include <stdio.h>

/* reads script to control playback of frames on a Panasonic TQ-2026F */

/* MODIFY for your installation */
#define BLANK_FRAME 23001



main (argc,argv)

int argc ;
char *argv[] ;

{
    FILE *in ;
    char line[80] ;
    char command[80] ;
    char tmp[80] ;
    long seconds ;
    long search_frame = 0L ;
    long playto_frame = 0L ;
    long prev_frame = 0L ;
    char mode[80] ;
    int speed = 1 ;
    int i ;

    if ((in = fopen (argv[1],"r")) == NULL)
    {
        fprintf (stderr,"no such script file\n") ;
        exit (-1) ;
    }
    if(init_pana(0) == 0)
    {
        fprintf(stderr,"Error initializing Panasonic TQ2026F recorder\n");
        exit(-1);
    }

    while ((fgets(line,80,in)) != NULL)
    {
	    /* if comment, print it out */
        if (line[0] == '#')
            fputs(line,stderr) ;
        else if ((strncmp("blank",line,5)) == 0)
	{
	    sprintf (tmp,"SR%d:",BLANK_FRAME) ;
#ifndef TEST
            com_send (tmp) ;
#endif
	}
        else if ((strncmp("hold",line,4)) == 0)
	{
	    sscanf (line,"%s %ld",command,&seconds) ;
            sprintf (tmp,"HT%ld:",seconds) ;
#ifndef TEST
            com_send (tmp) ;
#endif
	}
        else if ((strncmp("search",line,6)) == 0)
	{
	    sscanf (line,"%s %ld",command,&search_frame) ;
#ifdef TEST
	    printf ("%s %ld\n",command,search_frame) ;
#endif
            prev_frame = search_frame ;
	    sprintf (tmp,"SR%ld:",search_frame) ;
#ifdef TEST
            printf ("%s  ",tmp) ;
#else
            com_send (tmp) ;
#endif
	}
        else if ((strncmp("playto",line,6)) == 0)
	{
	    sscanf (line,"%s %ld %s %d",command,&playto_frame,
				       mode,&speed) ;
	    printf ("playing from %ld to %ld at 1/%d speed\n",prev_frame,playto_frame,speed) ;
            if (playto_frame >= prev_frame)
	        sprintf (tmp,"LF%d:%ld:",speed,playto_frame) ;
            else
	        sprintf (tmp,"LR%d:%ld:",speed,playto_frame) ;
#ifdef TEST
            printf ("%s\n",tmp) ;
#else
            com_send (tmp) ;
#endif
            prev_frame = playto_frame ;
	}
    }
    fclose(in) ;
}
