
/*********************************************************/
/*                                                       */
/*                      lzw_decomp.c                     */
/*                                                       */
/*     Data Decompression Routine using LZW algorithm    */
/*                                                       */
/*                                                       */
/*      The decompression routine takes in a RAM buffer  */
/*      "inbuf[]", decompress the codes and puts strings */
/*      to either the RAM buffer "outbuf[]" or to a disk */
/*      file. No extra string table is needed; the       */
/*      routine uses codes to rebuild the string table.  */
/*                                                       */
/*                                                       */
/*      This routine can be called as follows:           */
/*                                                       */
/*          lzw_decomp(inbuf, ibsize                     */
/*              unsigned char inbuf[];                   */
/*              int ibsize;                              */
/*          {                                            */
/*          }                                            */
/*                                                       */
/*      Note: uncompress.c is the LZW implementation on  */
/*            the SUN system.                            */
/*                                                       */
/*                            LBL 7/12/88                */
/*                                                       */
/*********************************************************/
#include "lzwdec.h" /* necessary LZW decomp constants */

int lzw_output_size ;

unsigned char outbuf[32767] ;

lzw_decomp(inbuf, ibsize) 
unsigned char inbuf[];     /* input buffer       */
int *ibsize;                /* input buffer size  */
{
    register char_type *stackp; /* internal buffer pointer */
    register int finchar;       /* next char in the stream */
    register code_int code, oldcode, incode; /* codes      */
    register out_count;         /* output stream counter   */
    code_int getcode();         /* function getcode()      */
    int i ;

    in_count = 2;          /* skip the first two magic codes */
    out_count = 0;         /* set output stream counter to 0 */

    maxcode = MAXCODE(n_bits = INIT_BITS); /* max code value */
    maxbits = inbuf[in_count++];       /* max # code of bits */
    block_compress = maxbits & BLOCK_MASK; /* block comp     */
    maxbits &= BIT_MASK;           /* recover # of code bits */
    maxmaxcode = 1 << maxbits;     /* set max code value     */


    /*
     * As above, initialize the first 256 entries in the table.
     */
    for ( code = 255; code >= 0; code-- ) 
    {
	tab_prefixof(code) = 0;
	tab_suffixof(code) = (char_type)code;
    }
    free_ent = ((block_compress) ? FIRST : 256 );

    finchar = oldcode = getcode(inbuf, *ibsize);/* get first code       */
    if(oldcode == -1)	           /* EOF already?                     */
	return;			   /* Get out of here                  */
    /*putc((char)finchar, outfp);	*/   /* first code must be 8 bits = char */
    outbuf[out_count++] = (char)finchar;
    stackp = de_stack;

    /* loop to get codes and to reconstruct strigs                     */
    while ( (code = getcode(inbuf, *ibsize)) > -1 ) 
    {
	if ( (code == CLEAR) && block_compress ) 
	{
	    for ( code = 255; code >= 0; code-- )
		tab_prefixof(code) = 0;
	    clear_flg = 1;
	    free_ent = FIRST - 1;
	    if (code = getcode(inbuf, *ibsize) == -1 )/* O,untimely death! */
		break;
	}
	incode = code;
	/*
	 * Special case for KwKwK string.
	 */
	if ( code >= free_ent ) 
	{
            *stackp++ = finchar;
	    code = oldcode;
	}

	/*
	 * Generate output characters in reverse order
	 */
	while ( code >= 256 ) 
	{
	    *stackp++ = tab_suffixof(code);
	    code = tab_prefixof(code);
	}
	*stackp++ = finchar = tab_suffixof(code);

	/*
	 * And put them out in forward order
	 */
	do
           /*
	    putc((char)*--stackp, outfp);
           */
            outbuf[out_count++] = (char)*--stackp;
	while ( stackp > de_stack );

	/*
	 * Generate the new entry.
	 */
	if ( (code=free_ent) < maxmaxcode ) 
	{
	    tab_prefixof(code) = (unsigned short)oldcode;
	    tab_suffixof(code) = finchar;
	    free_ent = code+1;
	} 
	/*
	 * Remember previous code.
	 */
	oldcode = incode;
    }
    for (i = 0 ; i < out_count ; i++)
	inbuf[i] = outbuf[i] ;
    *ibsize = out_count;
}





code_int
getcode(inbuf, ibsize) 
unsigned char inbuf[];
int ibsize;
{
    /*
     * On the VAX, it is important to have the register declarations
     * in exactly the order given, or the asm will break.
     */
    register code_int code;
    static int offset = 0, size = 0;
    static char_type buf[BITS];
    register int r_off, bits;
    register char_type *bp = buf;
    int i;

    if ( clear_flg > 0 || offset >= size || free_ent > maxcode ) {
	/*
	 * If the next entry will be too big for the current code
	 * size, then we must increase the size.  This implies reading
	 * a new buffer full, too.
	 */
	if ( free_ent > maxcode ) {
	    n_bits++;
	    if ( n_bits == maxbits )
		maxcode = maxmaxcode;	/* won't get any bigger now */
	    else
		maxcode = MAXCODE(n_bits);
	}
	if ( clear_flg > 0) {
    	    maxcode = MAXCODE (n_bits = INIT_BITS);
	    clear_flg = 0;
	}
	for (i=0; i<n_bits; i++)
	{
	    buf[i] = inbuf[in_count++];
        }
	size = n_bits;
        if (in_count >= ibsize)
	   size = ibsize - (in_count - n_bits);
	if ( size <= 0 )
        {
	    return -1;			/* end of file */
	}
	offset = 0;
	/* Round size down to integral number of codes */
	size = (size << 3) - (n_bits - 1);
    }
    r_off = offset;
    bits = n_bits;
	bp += (r_off >> 3);
	r_off &= 7;
	code = (*bp++ >> r_off);
	bits -= (8 - r_off);
	r_off = 8 - r_off;		/* now, offset into code word */
	if ( bits >= 8 )
	{
	    code |= *bp++ << r_off;
	    r_off += 8;
	    bits -= 8;
	}
	/* high order bits. */
	code |= (*bp & rmask[bits]) << r_off;
    offset += n_bits;

    return code;
}

