/* @(#)svc_run.c	1.3 87/11/13 3.9 RPCSRC */
#if !defined(lint) && defined(SCCSIDS)
static char sccsid[] = "@(#)svc_run.c 1.1 87/10/13 Copyr 1984 Sun Micro";
#endif

/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/*
 * This is the rpc server side idle loop
 * Wait for input, call server program.
 */
/* CHANGERPC */
#include <stdio.h>
/* end CHANGERPC */
#include <rpc/rpc.h>
/* CHANGERPC */
#ifdef LATER
#include <sys/errno.h>
#endif
#include <sys/time.h>
#include "svc.h"
#include "svc_auth.h"

extern long svc_fds ;

#define NOFILE 32

static struct timeval wait_per_try = { 0, 250000 };

/* end CHANGERPC */

void
svc_run()
{
#ifdef FD_SETSIZE
	fd_set readfds;
#else
/* CHANGERPC */
      long readfds;
#endif /* def FD_SETSIZE */
/*	extern int errno; */
        int i ;
	long nfds ;
/* end CHANGERPC */

	for (;;) {
#ifdef FD_SETSIZE
		readfds = svc_fdset;
#else
		readfds = svc_fds;
/* CHANGERPC */
/* some sort of system stuff goes on with a fprintf that allows
   the server to be interrupted; without this fprintf, you will
   not be able to ^C out of the server */

                fprintf (stderr,"s");
		fflush(stderr);
#endif /* def FD_SETSIZE */
/*
		switch (select(_rpc_dtablesize(), &readfds, (long *)0, (long *)0,
			       (struct timeval *0)) {
*/
		switch ((nfds=select(NOFILE, &readfds, (long *)0, (long *)0,
			       &wait_per_try))) {
		case -1:
#ifdef LATER
			if (errno == EINTR) {
				continue;
			}
#endif
			fprintf(stderr,"svc_run: - select failed");
/* end CHANGERPC */
			return;
		case 0:
			continue;
		default:
			svc_getreqset(&readfds);
		}
	}
}
