/* cccdec.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

#include	<stdio.h>
#include	<memory.h>
#include	<scry_image.h>


/* decompress_ccc:  decompress image that has been CCC and run length
		    compressed
   zoom_decompress:  decompress and zoom by a factor of 2 */


#define SIZBLOC 4	/* width and height of 4x4 block */

/* decompress image that has been CCC and run length compressed
   (i.e. IFF compression format) */

decompress_ccc (bufin, image_mem, height, width, xform_indices)

unsigned char bufin[] ;		/* compressed image */
unsigned char *image_mem ;	/* image memory */
int height ;			/* image height */
int width ;			/* image width */
int *xform_indices ;		/* used when using X windows for display */
	
{
    int	row = 0 ;
    unsigned char pix0, pix1 ;	/* the 2 colors in a 4x4 block */
    unsigned char *ptin ;	/* pointer to step through compressed image */
    unsigned char *ptbloc ;	/* steps through blocks of compressed image */
    int i, j ;
    unsigned int run_ctr ;
    int totblocks ;		/* total 4x4 blocks in image */
    int block_width_num ;	/* number of 4x4 blocks in row */
    int decal ;			/* steps through rows in 4x4 block */
    unsigned char tmp0, tmp1 ;

    block_width_num = width/SIZBLOC ;
    decal = width - SIZBLOC + 1 ;
    ptin = bufin ;
    run_ctr = 1 ;
    totblocks = block_width_num*(height/4) ;
       /* for all 4x4 blocks in image */
    for (i=0 ; i<totblocks ; i += run_ctr, ptbloc += (SIZBLOC*run_ctr))
    {
	    /* if at beginning of row */
	if ((i % block_width_num) == 0)
	{
            ptbloc = &(image_mem[row * width]) ;
	    row += 4 ;
	}
        tmp0 = *ptin++ ;
        tmp1 = *ptin++ ;
	    /* translate into X Windows index (unchanged when not
	       using X Windows */
        pix0 = (unsigned char) xform_indices[tmp0] ;
        pix1 = (unsigned char) xform_indices[tmp1] ;
	    /* if 2 different colors in block */
	if (tmp1 != tmp0)
        { 
            register unsigned char *ptc ;	/* pointer into ptbloc */
            register unsigned short bitmap ;	/* 4x4 bitmap */

	    run_ctr = 1 ;
	    bitmap = *ptin++ ;
	    bitmap = (bitmap << 8) | *ptin++ ;
                /* scan the bit map and assign the colors */
            ptc = ptbloc ;
            *ptc++ = (bitmap & 01) ? pix1 : pix0 ;
            *ptc++ = (bitmap & 02) ? pix1 : pix0 ;
            *ptc++ = (bitmap & 04) ? pix1 : pix0 ;
            *ptc = (bitmap & 010) ? pix1 : pix0 ;
            ptc += decal ;
            *ptc++ = ( bitmap & 020 ) ? pix1 : pix0 ; 
            *ptc++ = ( bitmap & 040 ) ? pix1 : pix0 ; 
            *ptc++ = ( bitmap & 0100 ) ? pix1 : pix0 ; 
            *ptc = ( bitmap & 0200 ) ? pix1 : pix0 ; 
            ptc += decal ;
            *ptc++ = ( bitmap & 0400 ) ? pix1 : pix0 ; 
            *ptc++ = ( bitmap & 01000 ) ? pix1 : pix0 ; 
            *ptc++ = ( bitmap & 02000 ) ? pix1 : pix0 ; 
            *ptc = ( bitmap & 04000 ) ? pix1 : pix0 ; 
            ptc += decal ;
            *ptc++ = ( bitmap & 010000 ) ? pix1 : pix0 ; 
            *ptc++ = ( bitmap & 020000 ) ? pix1 : pix0 ; 
            *ptc++ = ( bitmap & 040000 ) ? pix1 : pix0 ; 
            *ptc = ( bitmap & 0100000 ) ? pix1 : pix0 ; 
        }
        else		/* expand run */
        {
	    unsigned char *ptc ;

	    run_ctr = *ptin++ ;
	    run_ctr = (run_ctr << 8) | *ptin++ ;
	    if (run_ctr > block_width_num)
		fprintf (stderr,"bad run ctr: %d\n",run_ctr) ;
	    if ((memset(ptbloc,pix0,run_ctr*4)) == NULL)
		fprintf (stderr,"can't set run\n") ;
	    if ((memset(ptbloc+width,pix0,run_ctr*4)) == NULL)
		fprintf (stderr,"can't set run\n") ;
	    if ((memset(ptbloc+width*2,pix0,run_ctr*4)) == NULL)
		fprintf (stderr,"can't set run\n") ;
	    if ((memset(ptbloc+width*3,pix0,run_ctr*4)) == NULL)
		fprintf (stderr,"can't set run\n") ;
	}
    }			/* END FOR A GROUP OF LINES */
}




#define ZOOM_FACTOR 2

/* decompress and zoom by a factor of 2 */

zoom_decompress(bufin, image_mem, xform_indices)

unsigned char bufin[];		/* compressed image */
unsigned char *image_mem;	/* image memory */
int *xform_indices ;		/* used when using X windows for display */

{
    int row = 0 ;
    register unsigned char pix0, pix1;	/* 2 colors inside the 4x4 block */
        /* pointer stepping through compressed image */
    register unsigned char *ptin;
    register unsigned short bitmap;	/* bit map of one block */
    unsigned char *ptbloc;		/* pointer to beginning of block */
    register unsigned char *ptc;	/* pointer for ptbloc */
    register int i;
    unsigned char *copyline ;	/* used to speed up zooming */
    int run_ctr = 0 ;
    unsigned char tmp0, tmp1 ;
    int totblocks ;		/* total 4x4 blocks in image */
    int block_width_num ;	/* number of blocks in a row */
	/* used in stepping through rows of 4x4 block */
    int decal ;
    int skip ;

    block_width_num = (S_image_info.s_width / ZOOM_FACTOR) / SIZBLOC ;
    skip = SIZBLOC*ZOOM_FACTOR ;
    decal = S_image_info.s_width - skip + ZOOM_FACTOR ;
    totblocks = block_width_num * ((S_image_info.s_height / ZOOM_FACTOR) / SIZBLOC) ;
    ptin = bufin;
	/* for all 4x4 blocks */
    for(i = 0; i < totblocks ; i += run_ctr, ptbloc += (skip*run_ctr))
    {
	    /* if at beginning of row */
	if ((i % block_width_num) == 0)
	{
	    ptbloc = &(image_mem[row * S_image_info.s_width]) ;
	    row += SIZBLOC * ZOOM_FACTOR ;
        }
        tmp0 = *ptin++ ;
        tmp1 = *ptin++ ;
	    /* translate into X color map indices (xform_indices
	       is a linear ramp when not using X) */
        pix0 = (unsigned char) xform_indices[tmp0] ;
        pix1 = (unsigned char) xform_indices[tmp1] ;
	    /* if 2 colors in block */
	if (tmp1 != tmp0)
        { 
            run_ctr = 1 ;
               /* get bit map for one block */
            bitmap = *ptin++;
            bitmap = (bitmap << 8) |*ptin ;
            ++ptin;
                /* scan the bit map and assign the colors */
            copyline = ptc = ptbloc;
		/* zoom by a factor of 2 */
            *(ptc+1) = *ptc = (bitmap & 01) ? pix1 : pix0;
            ptc += 2 ;
            *(ptc+1) = *ptc = (bitmap & 02) ? pix1 : pix0;
            ptc += 2 ;
            *(ptc+1) = *ptc = (bitmap & 04) ? pix1 : pix0;
            ptc += 2 ;
            *(ptc+1) = *ptc = (bitmap & 010) ? pix1 : pix0;
            ptc += decal;
            bcopy (copyline,ptc,skip) ;
            copyline = ptc = ptc + S_image_info.s_width ;
            *(ptc+1) = *ptc = (bitmap & 020) ? pix1 : pix0;
            ptc += 2 ;
            *(ptc+1) = *ptc = (bitmap & 040) ? pix1 : pix0;
            ptc += 2 ;
            *(ptc+1) = *ptc = (bitmap & 0100) ? pix1 : pix0;
            ptc += 2 ;
            *(ptc+1) = *ptc = (bitmap & 0200) ? pix1 : pix0;
            ptc += decal;
            bcopy (copyline,ptc,skip) ;
            copyline = ptc = ptc + S_image_info.s_width ;
            *(ptc+1) = *ptc = (bitmap & 0400) ? pix1 : pix0;
            ptc += 2 ;
            *(ptc+1) = *ptc = (bitmap & 01000) ? pix1 : pix0;
            ptc += 2 ;
            *(ptc+1) = *ptc = (bitmap & 02000) ? pix1 : pix0;
            ptc += 2 ;
            *(ptc+1) = *ptc = (bitmap & 04000) ? pix1 : pix0;
            ptc += decal;
            bcopy (copyline,ptc,skip) ;
            copyline = ptc = ptc + S_image_info.s_width ;
            *(ptc+1) = *ptc = (bitmap & 010000) ? pix1 : pix0;
            ptc += 2 ;
            *(ptc+1) = *ptc = (bitmap & 020000) ? pix1 : pix0;
            ptc += 2 ;
            *(ptc+1) = *ptc = (bitmap & 040000) ? pix1 : pix0;
            ptc += 2 ;
            *(ptc+1) = *ptc = (bitmap & 0100000) ? pix1 : pix0;
            ptc += decal;
            bcopy (copyline,ptc,skip) ;
        }
        else	/* expand run length */
        {
            run_ctr = *ptin++ ;
            run_ctr = (run_ctr << 8) | *ptin++ ;
            if (run_ctr > block_width_num)
                fprintf (stderr,"bad run length\n") ;
            if ((memset(ptbloc,pix0,run_ctr*skip)) == NULL)
		printf ("can't set run\n") ;
	    if ((memset(ptbloc+S_image_info.s_width,pix0,run_ctr*skip)) == NULL)
		printf ("can't set run\n") ;
	    if ((memset(ptbloc+S_image_info.s_width*2,pix0,run_ctr*skip)) == NULL)
		printf ("can't set run\n") ;
	    if ((memset(ptbloc+S_image_info.s_width*3,pix0,run_ctr*skip)) == NULL)
		printf ("can't set run\n") ;
	    if ((memset(ptbloc+S_image_info.s_width*4,pix0,run_ctr*skip)) == NULL)
		printf ("can't set run\n") ;
	    if ((memset(ptbloc+S_image_info.s_width*5,pix0,run_ctr*skip)) == NULL)
		printf ("can't set run\n") ;
	    if ((memset(ptbloc+S_image_info.s_width*6,pix0,run_ctr*skip)) == NULL)
		printf ("can't set run\n") ;
	    if ((memset(ptbloc+S_image_info.s_width*7,pix0,run_ctr*skip)) == NULL)
		printf ("can't set run\n") ;
        }
    }
}
