/*	Copyright (c)

Disclaimer:  No guarantees of performance accompany this software,
nor is any responsibility assumed on the part of the authors.  All the
software has been tested extensively and every effort has been made to
insure its reliability.   */

/*
 * stdseq.c -  calculates the standard deviation of an image sequence
 *             pixel by pixel and stores the result.
 *             The sequence and the results are either integer or
 *             float format.
 *
 * usage:	stdseq	iseq.ave < iseq >oseq
 *              [ iseq.ave is the mean image of the iseq. ]
 *
 * to load:     compile stdseq	
 *
 *              6/29/87
 */

#include <stdio.h>
#include <hipl_format.h>
#include <math.h>
char *Progname;

main (argc,argv)

int argc;
char **argv;

{
	struct header hdf,hd;
	int fd,f,nrc,i,nbytes,nfr;
	float *fpic,*pic,*fvar,*fv,fdiv,*fp,*p;
	int *ifpic,*ipic,*ivar,*iv,idiv,*ifp,*ip;

	Progname = strsave(*argv);
	if (argv[argc][0]=='-' && argv[argc][1]=='D') argc--;
	if (argc<2)
		perr("file argument missing");
	if ((fd = open(argv[1],0)) == NULL)
		perr("can't open frame file - %s",argv[1]);
	read_header(&hd);
	fread_header(fd,&hdf);
	if (hd.rows != hdf.rows || hd.cols != hdf.cols ||
	    hd.pixel_format != hdf.pixel_format ||
	    hd.bit_packing != hdf.bit_packing)
		perr("frame file and input header mismatch");
	if (hd.pixel_format != PFFLOAT && hd.pixel_format != PFINT)
		perr("input must be float or integer");
	nrc = hd.rows*hd.cols;
        nfr =  hd.num_frame;
	hd.num_frame = 1;
	update_header(&hd,argc,argv);
	write_header(&hd);
	switch (hd.pixel_format) {
        case PFFLOAT:
                nbytes = nrc*sizeof(float);
		pic = (float *) halloc(nrc,sizeof(float));
		fpic= (float *) halloc(nrc,sizeof(float));
                fvar = (float *) halloc(nrc,sizeof(float));
		if (read(fd,fpic,nrc*sizeof(float))!=nrc*sizeof(float))
			perr("error during fixed frame read");
		for (f=0;f<nfr;f++) {
			if (pread(0,pic,nrc*sizeof(float))!=nrc*sizeof(float))
				perr("error during read");
			p = pic;
			fp = fpic;
                        fv = fvar;
			for (i=0;i<nrc;i++,fp++,p++)
	                    *fv++ = (*fp - *p)*(*fp - *p); 
		}
	case PFINT:
                nbytes = nrc*sizeof(int);
		ipic = (int *) halloc(nrc,sizeof(int));
		ifpic= (int *) halloc(nrc,sizeof(int));
                ivar = (int *) halloc(nrc,sizeof(int));
		if (read(fd,ifpic,nrc*sizeof(int))!=nrc*sizeof(int))
			perr("error during fixed frame read");
		for (f=0;f<nfr;f++) {
			if (pread(0,ipic,nrc*sizeof(int))!=nrc*sizeof(int))
				perr("error during read");
			ip = ipic;
			ifp = ifpic;
                        iv = ivar;
			for (i=0;i<nrc;i++,ifp++,ip++)
                            *iv++ = (*ifp - *ip)*(*ifp - *ip);
		}
	}
	switch (hd.pixel_format) {
	case PFFLOAT:
                fv = fvar;
		fdiv = (float) nfr - 1;
		for (i=0;i<nrc;i++,fv++)
			*fv = sqrt( (double) *fv / fdiv);
	if (write(1,fvar,nbytes) != nbytes)
		perr("error during write");
		break;
	case PFINT:
                iv = ivar;
		idiv = nfr - 1;
		for (i=0;i<nrc;i++,iv++)
			*iv = sqrt( (double) *iv / idiv);
	if (write(1,ivar,nbytes) != nbytes)
		perr("error during write");
		break;
	}

	return(0);
}
