
/*  segal.h : for use with the program 'segal'  by Brian Tierney, LBL */

/***********************************************************************/
/*  COPYRIGHT NOTICE         *******************************************/
/***********************************************************************/

/*   This program is copyright (C) 1990, Regents  of  the
University  of  California.   Anyone may reproduce this software,
in whole or in part, provided that:
(1)  Any copy  or  redistribution  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;
(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
to this software under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     This software is provided as a professional  academic
contribution for  joint exchange.  Thus it is experimental, is
provided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
Bug reports or fixes may be sent to the author, who may or may
not act on them as he desires.
*/

/*   Author:  Brian L. Tierney
 *            Lawrence Berkeley Laboratory
 *            Imaging and Distributed Computing Group
 *            email: bltierney@lbl.gov
*/
/**********************************************************************/
#include <stdio.h>
#include <memory.h>
#include <math.h>
#include <sys/param.h>
#include <sys/types.h>

/* xview/x windows include files */
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/cms.h>
#include <xview/cursor.h>
#include <xview/svrimage.h>
#include <xview/notice.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>

/* HIPS include file */
#include <hipl_format.h>

/* local include files */
#include "segal_ui.h"
#include "view_ui.h"
#include "pixedit_ui.h"

#define NGRAY 64		/* program scales all data in image to 0 to
				 * NGRAY (never set above 120) */
#define PVAL  255		/* high pixel value  */

#define ZOOM_WIN_SIZE 325       /* size of zoom window (fixed at compile) */

#define EDIT_CONTROL_HEIGHT 95    /* size of edit control panel */
#define EDIT_CONTROL_WIDTH 325

#define Calloc(x,y) (y *)calloc((unsigned)(x), sizeof(y))
#define Fread(a,b,c,d) fread((char *)(a), b, (int)(c), d)
#define Fwrite(a,b,c,d) fwrite((char *)(a), b, (int)(c), d)

/* useful structures */
typedef struct zi {
    int       size;             /* always square zoom window */
    int       x;		/* upper, left corner of zoom image */
    int       y;
    int       cx;               /* center of zoom window */
    int       cy;
    int       mag;
}         ZOOM_INFO;

typedef struct img {
    char     filename[80];
    u_char  **data;
    long      start;		/* position of first byte in file (after
				 * header ) */
    FILE     *fp;
}         IMAGE_INFO;

typedef struct info {
    int       mode;		/* 0 = image only, 1 = zoom, 3 = zoom & edit */
    int       rows;
    int       cols;
    int       frames;
    int       curr_frame;       /* numbered from 1, not 0  */
    int       changed;		/* flag to mask was editted */
  /* settings */
    int       poly_flag;        /* polygon mask mode */
    int       display_type;
    int       mask_type;
    int       blend_type;
    int       slider1;
    int       slider2;
}         SEGAL_INFO;

typedef struct ed_info {
    int       win_width;
    int       win_height;
    int       canvas_width;
    int       canvas_height;
    int       changing;      /* flag used by resize proc */
}         EDIT_INFO;

/* all of these are defined in segal.c */
extern IMAGE_INFO himage, hmask;
extern ZOOM_INFO zoom_info;
extern SEGAL_INFO segal;
extern EDIT_INFO edit_info;

extern int ac;                /* argc and argv, for use in update header */
extern char **av;

/* window stuff shared by all parts */
extern Display *display;
extern u_long *colors, standout;
extern GC gc;
extern int screen;
extern Xv_cmsdata cms_data;

/* XImages used everywhere */

extern XImage *image;
extern XImage *mask_image;
extern XImage *blend_image;

extern XImage *zoom_image;
extern XImage *zoom_mask_image;
extern XImage *zoom_blend_image;

extern u_char **work_buf;	/* used in editting */

#define MAX_CURSORS 50
typedef struct curs {
    Xv_Cursor paint;     /* round cursors */
    Xv_Cursor erase;
    Xv_Cursor sq_paint;  /* square cursors */
    Xv_Cursor sq_erase;
    u_char **paint_mask;
    int size;
    int radius;
    int corner;
} SEGAL_CURSOR;

/* in cursor.c */
extern SEGAL_CURSOR my_cursor[MAX_CURSORS];

/* cursor used everywhere */
extern Cursor watch_cursor;

/* xid's needed everywhere */
extern XID view_xid, edit_xid, edit_control_xid, segal_control_xid;

/* global flag for indicating whether to print status/debug messages */
int verbose;

/* routines used everywhere */
void image_repaint_proc(), edit_repaint_proc(), map_image_to_lut();
void blend(), zoom();

