/*
 * popup.c    routines used with popup window buttons in
 *            segal.c
 *
 *   Brian Tierney, LBL   5/90
 */
#include "segal.h"

/* these need to be global */
extern pixedit_win_objects *edit_win;
extern view_win_objects *view_win;
extern segal_win_objects *segal_win;
extern segal_popup_win_objects *segal_popup_win;

/**********************************************************/
/* popups windows                                         */
/**********************************************************/
void
load_image_mask_popup()
{
    char fname[120];

    (void) xv_set(segal_popup_win->message1, PANEL_LABEL_STRING,
		  "Mask image not loaded! ", NULL);
    (void) xv_set(segal_popup_win->message2, PANEL_LABEL_STRING,
		  "Load mask image?", NULL);

    XBell(display, 50);

    strcpy(fname, xv_get(segal_win->image2, PANEL_VALUE, NULL));
    if (fname == NULL || (strlen(fname) == 0)) {
	strcpy(fname, himage.filename);
	strcat(fname, ".mask");
    }
    xv_set(segal_popup_win->filename_item, PANEL_VALUE, fname, NULL);

    xv_set(segal_popup_win->popup_win, WIN_SHOW, TRUE, NULL);
}

/**********************************************************/
void
ok_proc(item, event)		/* popup window ok button  */
    Panel_item item;
    Event    *event;
{
    char     *fname;
    void      write_blank_mask(), edit_setup();

    fname = (char *) xv_get(segal_popup_win->filename_item, PANEL_VALUE, NULL);

    if (strcmp(fname, himage.filename) == 0) {
	fprintf(stderr, "Error: mask and image must be different file names\n");
	return;
    }

    strcpy(hmask.filename, fname);
    (void) xv_set(segal_win->image2, PANEL_VALUE, fname, NULL);

    set_watch_cursor();
    if (load_mask(item) < 0) {
	segal.mode = 0;
	xv_set(segal_win->mode_item, PANEL_VALUE, 0, NULL);
	unset_watch_cursor();
	return;
    }

    map_image_to_lut(hmask.data[0], mask_image->data,
		     segal.rows * segal.cols);

    blend(himage.data[0], hmask.data[0], (u_char *) blend_image->data,
	  segal.rows * segal.cols);

    edit_setup();
    edit_repaint_proc();

    (void) xv_set(segal_win->image2, PANEL_VALUE, fname, NULL);

    segal.mode = 2;
    xv_set(segal_popup_win->popup_win, WIN_SHOW, FALSE, NULL);

    unset_watch_cursor();
}

/*********************************************/
void
cancel_proc()
{				/* closes popup window */
    /* change back to previous mode if user selects cancel */
    xv_set(segal_win->mode_item, PANEL_VALUE, segal.mode, NULL);

    xv_set(segal_popup_win->popup_win, WIN_SHOW, FALSE, NULL);
}
