.\" Copyright (c) 1986, University of Utah
.\" Template man page.  Taken from wtm's page for getcx3d
.\" Modified to fix some mistakes by Fritz Renema 8/4/88.
.TH HFANT 1 "November 11, 1985" 1
.UC 4 
.SH NAME
hfant \- perform simple spatial transforms on a hips sequence of images
.SH SYNOPSIS
.B hfant
.\" sample options...
[
.B \-s 
.I "xscale yscale"
] [
.B \-v
]
[
.B \-a
.I "angle"
] [
.B \-o
.I "xoff yoff"
]
< infile > outfile 
.SH DESCRIPTION
.IR hfant
rotates or scales an image by an arbitrary amount.  It does this by
using pixel integration (if the image size is reduced) or pixel interpolation
if the image size is increased.  Because it works with subpixel precision,
aliasing artifacts are not introduced.  Fant uses a two-pass sampling
technique to perform the transformation.

The following options are available:

.TP
.B "\-s xscale yscale"
The amount (in real numbers) to scale an image by.  This is often useful
for correcting the aspect of an image for display on a frame buffer with
non square pixels.  For this use, the origin should be specified as 0, 0
(see below).  If an image is only scaled in Y and no rotation is performed,
.IR hfant 
only uses one sampling pass over the image, cutting the computation time
in half.

.TP
.B "\-a angle"
Amount to rotate image by, a real number from 0 to 45 degrees (positive
numbers rotate clockwise).  Use rleflip(1) first to rotate an image by larger
amounts.

.TP
.B "\-o xoff yoff"
Specifies where the origin of the image is - the image is rotated or scaled
about this point.  If no origin is specified, the center of the image is used.

.LP
.SH SEE ALSO
.IR avg4(1), 
.IR rleflip(1)
.IR RLE (5).
.SH AUTHOR
John W. Peterson
.sp
Brian Tierney (LBL) converted for hips file format (9/89)
.SH BUGS
.IR hfant
was implemented with floating point arithmetic.  It would undoubtedly run
faster if interger arithmatic was used.

Negative rotations are implemented but don't quite work right.
