#include <rpc/rpc.h>
#include "rrpc.h"


bool_t
xdr_RRConnection(xdrs, objp)
	XDR *xdrs;
	RRConnection *objp;
{
	if (!xdr_nm(xdrs, &objp->progname)) {
		return (FALSE);
	}
	if (!xdr_nm(xdrs, &objp->clientname)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->clientno)) {
		return (FALSE);
	}
	if (!xdr_nm(xdrs, &objp->servername)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->servno)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->transport)) {
		return (FALSE);
	}
	if (!xdr_bool(xdrs, &objp->busy)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_rpc_Pixel(xdrs, objp)
	XDR *xdrs;
	rpc_Pixel *objp;
{
	if (!xdr_u_char(xdrs, &objp->r)) {
		return (FALSE);
	}
	if (!xdr_u_char(xdrs, &objp->g)) {
		return (FALSE);
	}
	if (!xdr_u_char(xdrs, &objp->b)) {
		return (FALSE);
	}
	if (!xdr_u_char(xdrs, &objp->alpha)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_RRreq(xdrs, objp)
	XDR *xdrs;
	RRreq *objp;
{
	if (!xdr_u_long(xdrs, &objp->RRID)) {
		return (FALSE);
	}
	if (!xdr_RRConnection(xdrs, &objp->connect)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->frame)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->minx)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->maxx)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->miny)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->maxy)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->size)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->sequence)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_rpc_square(xdrs, objp)
	XDR *xdrs;
	rpc_square *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->pixels.pixels_val, (u_int *)&objp->pixels.pixels_len, ~0, sizeof(rpc_Pixel), xdr_rpc_Pixel)) {
		return (FALSE);
	}
	if (!xdr_RRreq(xdrs, &objp->req)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_rpc_op_square(xdrs, objp)
	XDR *xdrs;
	rpc_op_square *objp;
{
	if (!xdr_bytes(xdrs, (char **)&objp->pixels.pixels_val, (u_int *)&objp->pixels.pixels_len, ~0)) {
		return (FALSE);
	}
	if (!xdr_RRreq(xdrs, &objp->req)) {
		return (FALSE);
	}
	return (TRUE);
}


#include <limits.h>
/************** custom string filter when char* points to zero *******/
bool_t xdr_nm(xdr,objp)
        XDR *xdr;
        nm  *objp;
{
        bool_t a;
        a=(bool_t)*objp;
         if(!xdr_bool(xdr,&a))
            return(FALSE);
         if(!a)
            return (TRUE);
         if(xdr->x_op==XDR_DECODE){
               *objp=NULL;
               }
         return xdr_string(xdr,objp,ULONG_MAX);
}

