#
# This awk script will convert an NFF-format input file (as output by
# Eric Haines' SPD) to something rayshade can understand.
# The World object will be enclosed in a single grid of 22*22*22 voxels.
#
# Example usage:
#	mountains | awk -f nff2shade.awk | rayshade > mountains.rle
#
# For best results, one should modify the output for all but the tetra
# and mountain databases to provide a tighter bounding box around the
# object of interest (tree, gears, etc.).  This is done by placing
# all primitives but the ground pologon into an object stored as a Grid,
# and then instantiating that object once.  This will decrease ray-tracing
# time dramatically.
#
# $Id: nff2shade.awk,v 3.0 89/10/27 01:30:24 craig Exp $
#
# $Log:	nff2shade.awk,v $
# Revision 3.0  89/10/27  01:30:24  craig
# Baseline for first official release.
# 
# C. Kolb 9/21/89
# Fixed comment bug; check first character rather than first field for "#".
# Keep track of defined surfaces in associative array so if one is used
# again we don't create another copy.
# Halved ambient intensity of surfaces.
# C. Kolb 10/12/89
# Added "adaptive 0" and "cutoff 0" to BEGIN and removed "endfile" from END.
# C. Kolb 2/89
# First version.
#
BEGIN{
	lights = 0;
	surfs = 0;
	print "maxdepth 4"
	print "adaptive 0"
	print "cutoff 0."
}
substr($1, 1, 1) == "#" { print "/* " $0 " */"; next;}
$1 == "v" { next;}
$1 == "from" { print "eyep " $2 " "$3 " " $4; next;}
$1 == "at" {print "lookp " $2 " "$3 " "$4; next;}
$1 == "up" {print; next;}
$1 == "angle" { print "fov " $2; next;}
$1 == "hither" {next;}
$1 == "resolution" {print "screen " $2 " "$3; next;}

$1 == "l" { lightd[lights] = $2 " "$3 " "$4; lights++; next; }
$1 == "b" {print "background " $2 " "$3 " "$4; next; }
$1 == "f" {
	if (surfaces[$2 $3 $4 $5 $6 $7 $8] != 0) {
		cursurf = surfaces[$2 $3 $4 $5 $6 $7 $8];
		next;
	}
	surfs++;
	surfaces[$2 $3 $4 $5 $6 $7 $8] = surfs;
	cursurf = surfs;
	aintens = sqrt(lights) / (4*lights);
	dr = $2*$5;
	dg = $3*$5;
	db = $4*$5;
# this is a good guess....
	ar = aintens*dr;
	ag = aintens*dg;
	ab = aintens*db;
#
# We set "reflectance" to the minimum of Ks and 1. - T, as
# Eric Haines' SPD includes several objects which have Ks + T > 1.
#
	if ($6 < 1. - $8)
		reflect = $6;
	else
		reflect = 1. - $8;
	printf("surface s%d  %f %f %f  %f %f %f  %f %f %f  %f %f %f %f\n", \
		cursurf, ar, ag, ab, dr, dg, db, $6, $6, $6, $7, reflect, $8, $9);
	next;
}

$1 == "c" {
	getline;
	x1 = $1;
	y1 = $2;
	z1 = $3;
	br = $4;
	getline;
	printf("cone s%d %f %f %f %f %f %f %f %f\n", \
		cursurf, x1, y1, z1, $1, $2, $3, br, $4);
	next;
}
$1 == "s" {
	print "sphere s"cursurf " "$5 " "$2 " "$3 " "$4;
	next;
}
$1 == "pp" {
	if ($2 == 3)
		print "triangle s"cursurf;
	else
		print "poly s"cursurf;
	next;
}
$1 == "p" {
#
# Polygon -- the vertices will print out in the default statement.
# If there are three vertices, make it a triangle.
#
	if ($2 == 3)
		print "triangle s"cursurf;
	else
		print "poly s"cursurf;
	next;
}
{
# Matched nothing (or is a vertex data) -- print it.
	print;
	next;
}
END{
#
# Output light definitions.
#
	intens = sqrt(lights) / (lights);
	for (i = 0; i < lights; i++) {
		print "light " intens " point " lightd[i]
	}
	print "grid 22 22 22"
}
